/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure.blob;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.druid.storage.azure.blob.CloudBlobHolder;

public class ListBlobItemHolder {
    private final ListBlobItem delegate;

    @AssistedInject
    public ListBlobItemHolder(@Assisted ListBlobItem delegate) {
        this.delegate = delegate;
    }

    public String getContainerName() throws URISyntaxException, StorageException {
        return this.delegate.getContainer().getName();
    }

    public URI getUri() {
        return this.delegate.getUri();
    }

    public CloudBlobHolder getCloudBlob() {
        return new CloudBlobHolder((CloudBlob)this.delegate);
    }

    public boolean isCloudBlob() {
        return this.delegate instanceof CloudBlob;
    }

    public String toString() {
        return this.delegate.toString();
    }
}

