/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication.endpoint;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.security.basic.BasicSecurityResourceFilter;
import org.apache.druid.security.basic.authentication.endpoint.BasicAuthenticatorResourceHandler;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorCredentialUpdate;
import org.apache.druid.server.security.AuthValidator;

@Path(value="/druid-ext/basic-security/authentication")
@LazySingleton
public class BasicAuthenticatorResource {
    private final BasicAuthenticatorResourceHandler handler;
    private final AuthValidator authValidator;

    @Inject
    public BasicAuthenticatorResource(BasicAuthenticatorResourceHandler handler, AuthValidator authValidator) {
        this.handler = handler;
        this.authValidator = authValidator;
    }

    @GET
    @Path(value="/loadStatus")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getLoadStatus(@Context HttpServletRequest req) {
        return this.handler.getLoadStatus();
    }

    @GET
    @Path(value="/refreshAll")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response refreshAll(@Context HttpServletRequest req) {
        return this.handler.refreshAll();
    }

    @GET
    @Path(value="/db/{authenticatorName}/users")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getAllUsers(@Context HttpServletRequest req, @PathParam(value="authenticatorName") String authenticatorName) {
        this.authValidator.validateAuthenticatorName(authenticatorName);
        return this.handler.getAllUsers(authenticatorName);
    }

    @GET
    @Path(value="/db/{authenticatorName}/users/{userName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getUser(@Context HttpServletRequest req, @PathParam(value="authenticatorName") String authenticatorName, @PathParam(value="userName") String userName) {
        this.authValidator.validateAuthenticatorName(authenticatorName);
        return this.handler.getUser(authenticatorName, userName);
    }

    @POST
    @Path(value="/db/{authenticatorName}/users/{userName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response createUser(@Context HttpServletRequest req, @PathParam(value="authenticatorName") String authenticatorName, @PathParam(value="userName") String userName) {
        this.authValidator.validateAuthenticatorName(authenticatorName);
        return this.handler.createUser(authenticatorName, userName);
    }

    @DELETE
    @Path(value="/db/{authenticatorName}/users/{userName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response deleteUser(@Context HttpServletRequest req, @PathParam(value="authenticatorName") String authenticatorName, @PathParam(value="userName") String userName) {
        this.authValidator.validateAuthenticatorName(authenticatorName);
        return this.handler.deleteUser(authenticatorName, userName);
    }

    @POST
    @Path(value="/db/{authenticatorName}/users/{userName}/credentials")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response updateUserCredentials(@Context HttpServletRequest req, @PathParam(value="authenticatorName") String authenticatorName, @PathParam(value="userName") String userName, BasicAuthenticatorCredentialUpdate update) {
        this.authValidator.validateAuthenticatorName(authenticatorName);
        return this.handler.updateUserCredentials(authenticatorName, userName, update);
    }

    @GET
    @Path(value="/db/{authenticatorName}/cachedSerializedUserMap")
    @Produces(value={"application/x-jackson-smile"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getCachedSerializedUserMap(@Context HttpServletRequest req, @PathParam(value="authenticatorName") String authenticatorName) {
        this.authValidator.validateAuthenticatorName(authenticatorName);
        return this.handler.getCachedSerializedUserMap(authenticatorName);
    }

    @POST
    @Path(value="/listen/{authenticatorName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response authenticatorUpdateListener(@Context HttpServletRequest req, @PathParam(value="authenticatorName") String authenticatorName, byte[] serializedUserMap) {
        this.authValidator.validateAuthenticatorName(authenticatorName);
        return this.handler.authenticatorUserUpdateListener(authenticatorName, serializedUserMap);
    }
}

