/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization.endpoint;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.security.basic.BasicSecurityResourceFilter;
import org.apache.druid.security.basic.authorization.endpoint.BasicAuthorizerResourceHandler;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerGroupMapping;
import org.apache.druid.server.security.AuthValidator;
import org.apache.druid.server.security.ResourceAction;

@Path(value="/druid-ext/basic-security/authorization")
@LazySingleton
public class BasicAuthorizerResource {
    private final BasicAuthorizerResourceHandler resourceHandler;
    private final AuthValidator authValidator;

    @Inject
    public BasicAuthorizerResource(BasicAuthorizerResourceHandler resourceHandler, AuthValidator authValidator) {
        this.resourceHandler = resourceHandler;
        this.authValidator = authValidator;
    }

    @GET
    @Path(value="/loadStatus")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getLoadStatus(@Context HttpServletRequest req) {
        return this.resourceHandler.getLoadStatus();
    }

    @GET
    @Path(value="/refreshAll")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response refreshAll(@Context HttpServletRequest req) {
        return this.resourceHandler.refreshAll();
    }

    @GET
    @Path(value="/db/{authorizerName}/users")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getAllUsers(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.getAllUsers(authorizerName);
    }

    @GET
    @Path(value="/db/{authorizerName}/groupMappings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getAllGroupMappings(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.getAllGroupMappings(authorizerName);
    }

    @GET
    @Path(value="/db/{authorizerName}/users/{userName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getUser(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="userName") String userName, @QueryParam(value="full") String full, @QueryParam(value="simplifyPermissions") String simplifyPermissions) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.getUser(authorizerName, userName, full != null, simplifyPermissions != null);
    }

    @GET
    @Path(value="/db/{authorizerName}/groupMappings/{groupMappingName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getGroupMapping(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="groupMappingName") String groupMappingName, @QueryParam(value="full") String full) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.getGroupMapping(authorizerName, groupMappingName, full != null);
    }

    @POST
    @Path(value="/db/{authorizerName}/users/{userName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response createUser(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="userName") String userName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.createUser(authorizerName, userName);
    }

    @DELETE
    @Path(value="/db/{authorizerName}/users/{userName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response deleteUser(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="userName") String userName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.deleteUser(authorizerName, userName);
    }

    @POST
    @Path(value="/db/{authorizerName}/groupMappings/{groupMappingName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response createGroupMapping(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="groupMappingName") String groupMappingName, BasicAuthorizerGroupMapping groupMapping) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.createGroupMapping(authorizerName, new BasicAuthorizerGroupMapping(groupMappingName, groupMapping.getGroupPattern(), groupMapping.getRoles()));
    }

    @DELETE
    @Path(value="/db/{authorizerName}/groupMappings/{groupMappingName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response deleteGroupMapping(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="groupMappingName") String groupMappingName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.deleteGroupMapping(authorizerName, groupMappingName);
    }

    @GET
    @Path(value="/db/{authorizerName}/roles")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getAllRoles(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.getAllRoles(authorizerName);
    }

    @GET
    @Path(value="/db/{authorizerName}/roles/{roleName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getRole(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="roleName") String roleName, @QueryParam(value="full") String full, @QueryParam(value="simplifyPermissions") String simplifyPermissions) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.getRole(authorizerName, roleName, full != null, simplifyPermissions != null);
    }

    @POST
    @Path(value="/db/{authorizerName}/roles/{roleName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response createRole(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="roleName") String roleName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.createRole(authorizerName, roleName);
    }

    @DELETE
    @Path(value="/db/{authorizerName}/roles/{roleName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response deleteRole(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="roleName") String roleName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.deleteRole(authorizerName, roleName);
    }

    @POST
    @Path(value="/db/{authorizerName}/users/{userName}/roles/{roleName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response assignRoleToUser(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="userName") String userName, @PathParam(value="roleName") String roleName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.assignRoleToUser(authorizerName, userName, roleName);
    }

    @DELETE
    @Path(value="/db/{authorizerName}/users/{userName}/roles/{roleName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response unassignRoleFromUser(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="userName") String userName, @PathParam(value="roleName") String roleName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.unassignRoleFromUser(authorizerName, userName, roleName);
    }

    @POST
    @Path(value="/db/{authorizerName}/groupMappings/{groupMappingName}/roles/{roleName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response assignRoleToGroupMapping(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="groupMappingName") String groupMappingName, @PathParam(value="roleName") String roleName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.assignRoleToGroupMapping(authorizerName, groupMappingName, roleName);
    }

    @DELETE
    @Path(value="/db/{authorizerName}/groupMappings/{groupMappingName}/roles/{roleName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response unassignRoleFromGroupMapping(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="groupMappingName") String groupMappingName, @PathParam(value="roleName") String roleName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.unassignRoleFromGroupMapping(authorizerName, groupMappingName, roleName);
    }

    @POST
    @Path(value="/db/{authorizerName}/roles/{roleName}/permissions")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response setRolePermissions(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="roleName") String roleName, List<ResourceAction> permissions) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.setRolePermissions(authorizerName, roleName, permissions);
    }

    @GET
    @Path(value="/db/{authorizerName}/roles/{roleName}/permissions")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getRolePermissions(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, @PathParam(value="roleName") String roleName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.getRolePermissions(authorizerName, roleName);
    }

    @GET
    @Path(value="/db/{authorizerName}/cachedSerializedUserMap")
    @Produces(value={"application/x-jackson-smile"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getCachedSerializedUserMap(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.getCachedUserMaps(authorizerName);
    }

    @GET
    @Path(value="/db/{authorizerName}/cachedSerializedGroupMappingMap")
    @Produces(value={"application/x-jackson-smile"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response getCachedSerializedGroupMap(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.getCachedGroupMappingMaps(authorizerName);
    }

    @POST
    @Path(value="/listen/{authorizerName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    @Deprecated
    public Response authorizerUpdateListener(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, byte[] serializedUserAndRoleMap) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.authorizerUserUpdateListener(authorizerName, serializedUserAndRoleMap);
    }

    @POST
    @Path(value="/listen/users/{authorizerName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response authorizerUserUpdateListener(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, byte[] serializedUserAndRoleMap) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.authorizerUserUpdateListener(authorizerName, serializedUserAndRoleMap);
    }

    @POST
    @Path(value="/listen/groupMappings/{authorizerName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={BasicSecurityResourceFilter.class})
    public Response authorizerGroupMappingUpdateListener(@Context HttpServletRequest req, @PathParam(value="authorizerName") String authorizerName, byte[] serializedGroupMappingAndRoleMap) {
        this.authValidator.validateAuthorizerName(authorizerName);
        return this.resourceHandler.authorizerGroupMappingUpdateListener(authorizerName, serializedGroupMappingAndRoleMap);
    }
}

