/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.druid.jackson.DefaultTrueJsonIncludeFilter;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.StringEncoding;
import org.apache.druid.java.util.common.StringEncodingDefaultUTF16LEJsonIncludeFilter;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchHolder;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeAggregatorFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;

public abstract class HllSketchAggregatorFactory
extends AggregatorFactory {
    public static final boolean DEFAULT_ROUND = false;
    public static final boolean DEFAULT_SHOULD_FINALIZE = true;
    public static final int DEFAULT_LG_K = 12;
    public static final TgtHllType DEFAULT_TGT_HLL_TYPE = TgtHllType.HLL_4;
    public static final StringEncoding DEFAULT_STRING_ENCODING = StringEncoding.UTF16LE;
    static final Comparator<HllSketchHolder> COMPARATOR = Comparator.nullsFirst(Comparator.comparingDouble(HllSketchHolder::getEstimate));
    private final String name;
    private final String fieldName;
    private final int lgK;
    private final TgtHllType tgtHllType;
    private final StringEncoding stringEncoding;
    private final boolean shouldFinalize;
    private final boolean round;

    HllSketchAggregatorFactory(String name, String fieldName, @Nullable Integer lgK, @Nullable String tgtHllType, @Nullable StringEncoding stringEncoding, Boolean shouldFinalize, boolean round) {
        this.name = Objects.requireNonNull(name);
        this.fieldName = Objects.requireNonNull(fieldName);
        this.lgK = lgK == null ? 12 : lgK;
        this.tgtHllType = tgtHllType == null ? DEFAULT_TGT_HLL_TYPE : TgtHllType.valueOf((String)tgtHllType);
        this.stringEncoding = stringEncoding == null ? DEFAULT_STRING_ENCODING : stringEncoding;
        this.shouldFinalize = shouldFinalize == null ? true : shouldFinalize;
        this.round = round;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getLgK() {
        return this.lgK;
    }

    @JsonProperty
    public String getTgtHllType() {
        return this.tgtHllType.toString();
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=StringEncodingDefaultUTF16LEJsonIncludeFilter.class)
    public StringEncoding getStringEncoding() {
        return this.stringEncoding;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=DefaultTrueJsonIncludeFilter.class)
    public boolean isShouldFinalize() {
        return this.shouldFinalize;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isRound() {
        return this.round;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public HllSketchHolder deserialize(Object object) {
        if (object == null) {
            return HllSketchHolder.of(new HllSketch(this.lgK, this.tgtHllType));
        }
        return HllSketchHolder.fromObj(object);
    }

    public Object combine(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return ((HllSketchHolder)lhs).merge((HllSketchHolder)rhs);
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new ObjectAggregateCombiner<HllSketchHolder>(){
            private final Union union;
            {
                this.union = new Union(HllSketchAggregatorFactory.this.lgK);
            }

            public void reset(ColumnValueSelector selector) {
                this.union.reset();
                this.fold(selector);
            }

            public void fold(ColumnValueSelector selector) {
                HllSketchHolder sketchHolder = (HllSketchHolder)selector.getObject();
                if (sketchHolder != null) {
                    this.union.update(sketchHolder.getSketch());
                }
            }

            @Nullable
            public HllSketchHolder getObject() {
                return HllSketchHolder.of(this.union.getResult(HllSketchAggregatorFactory.this.tgtHllType));
            }

            public Class<HllSketchHolder> classOfObject() {
                return HllSketchHolder.class;
            }
        };
    }

    public ColumnType getResultType() {
        if (this.shouldFinalize) {
            return this.round ? ColumnType.LONG : ColumnType.DOUBLE;
        }
        return this.getIntermediateType();
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        if (!this.shouldFinalize) {
            return object;
        }
        if (object == null) {
            return 0.0;
        }
        HllSketchHolder sketch = HllSketchHolder.fromObj(object);
        double estimate = sketch.getEstimate();
        if (this.round) {
            return Math.round(estimate);
        }
        return estimate;
    }

    public Comparator<HllSketchHolder> getComparator() {
        return COMPARATOR;
    }

    public AggregatorFactory getCombiningFactory() {
        return new HllSketchMergeAggregatorFactory(this.getName(), this.getName(), this.getLgK(), this.getTgtHllType(), this.getStringEncoding(), this.isShouldFinalize(), this.isRound());
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(this.getCacheTypeId()).appendString(this.name).appendString(this.fieldName).appendInt(this.lgK).appendInt(this.tgtHllType.ordinal()).appendCacheable((Cacheable)this.stringEncoding).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HllSketchAggregatorFactory that = (HllSketchAggregatorFactory)((Object)o);
        return this.lgK == that.lgK && this.shouldFinalize == that.shouldFinalize && this.round == that.round && Objects.equals(this.name, that.name) && Objects.equals(this.fieldName, that.fieldName) && this.tgtHllType == that.tgtHllType && this.stringEncoding == that.stringEncoding;
    }

    @Nullable
    public AggregatorFactory substituteCombiningFactory(AggregatorFactory preAggregated) {
        if (this == preAggregated) {
            return this.getCombiningFactory();
        }
        if (((Object)((Object)this)).getClass() != preAggregated.getClass()) {
            return null;
        }
        HllSketchAggregatorFactory that = (HllSketchAggregatorFactory)preAggregated;
        if (this.lgK <= that.lgK && this.stringEncoding == that.stringEncoding && Objects.equals(this.fieldName, that.fieldName)) {
            return this.getCombiningFactory();
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.lgK, this.tgtHllType, this.stringEncoding, this.shouldFinalize, this.round);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{name='" + this.name + "', fieldName='" + this.fieldName + "', lgK=" + this.lgK + ", tgtHllType=" + this.tgtHllType + (String)(this.stringEncoding != DEFAULT_STRING_ENCODING ? ", stringEncoding=" + this.stringEncoding : "") + (String)(!this.shouldFinalize ? ", shouldFinalize=" + this.shouldFinalize : "") + (String)(this.round ? ", round=" + this.round : "") + "}";
    }

    protected abstract byte getCacheTypeId();
}

