/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.google;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.services.storage.model.StorageObject;
import java.math.BigInteger;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.google.GoogleCloudStorageEntity;
import org.apache.druid.data.input.impl.CloudObjectInputSource;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.google.GoogleInputDataConfig;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleUtils;
import org.apache.druid.utils.Streams;

public class GoogleCloudStorageInputSource
extends CloudObjectInputSource {
    private static final Logger LOG = new Logger(GoogleCloudStorageInputSource.class);
    private final GoogleStorage storage;
    private final GoogleInputDataConfig inputDataConfig;

    @JsonCreator
    public GoogleCloudStorageInputSource(@JacksonInject GoogleStorage storage, @JacksonInject GoogleInputDataConfig inputDataConfig, @JsonProperty(value="uris") @Nullable List<URI> uris, @JsonProperty(value="prefixes") @Nullable List<URI> prefixes, @JsonProperty(value="objects") @Nullable List<CloudObjectLocation> objects) {
        super("gs", uris, prefixes, objects);
        this.storage = storage;
        this.inputDataConfig = inputDataConfig;
    }

    protected InputEntity createEntity(CloudObjectLocation location) {
        return new GoogleCloudStorageEntity(this.storage, location);
    }

    protected Stream<InputSplit<List<CloudObjectLocation>>> getPrefixesSplitStream(@Nonnull SplitHintSpec splitHintSpec) {
        Iterator splitIterator = splitHintSpec.split(this.storageObjectIterable().iterator(), storageObject -> {
            long sizeInLong;
            BigInteger sizeInBigInteger = storageObject.getSize();
            if (sizeInBigInteger == null) {
                sizeInLong = Long.MAX_VALUE;
            } else {
                try {
                    sizeInLong = sizeInBigInteger.longValueExact();
                }
                catch (ArithmeticException e) {
                    LOG.warn((Throwable)e, "The object [%s, %s] has a size [%s] out of the range of the long type. The max long value will be used for its size instead.", new Object[]{storageObject.getBucket(), storageObject.getName(), sizeInBigInteger});
                    sizeInLong = Long.MAX_VALUE;
                }
            }
            return new InputFileAttribute(sizeInLong);
        });
        return Streams.sequentialStreamFrom((Iterator)splitIterator).map(objects -> objects.stream().map(this::byteSourceFromStorageObject).collect(Collectors.toList())).map(InputSplit::new);
    }

    public SplittableInputSource<List<CloudObjectLocation>> withSplit(InputSplit<List<CloudObjectLocation>> split) {
        return new GoogleCloudStorageInputSource(this.storage, this.inputDataConfig, null, null, (List)split.get());
    }

    private CloudObjectLocation byteSourceFromStorageObject(StorageObject storageObject) {
        return GoogleUtils.objectToCloudObjectLocation(storageObject);
    }

    private Iterable<StorageObject> storageObjectIterable() {
        return () -> GoogleUtils.lazyFetchingStorageObjectsIterator(this.storage, this.getPrefixes().iterator(), this.inputDataConfig.getMaxListingLength());
    }

    public String toString() {
        return "GoogleCloudStorageInputSource{uris=" + this.getUris() + ", prefixes=" + this.getPrefixes() + ", objects=" + this.getObjects() + '}';
    }
}

