/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.firehose.google;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.prefetch.PrefetchableTextFilesFirehoseFactory;
import org.apache.druid.firehose.google.GoogleBlob;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.google.GoogleByteSource;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleUtils;
import org.apache.druid.utils.CompressionUtils;

public class StaticGoogleBlobStoreFirehoseFactory
extends PrefetchableTextFilesFirehoseFactory<GoogleBlob> {
    private final GoogleStorage storage;
    private final List<GoogleBlob> blobs;

    @JsonCreator
    public StaticGoogleBlobStoreFirehoseFactory(@JacksonInject GoogleStorage storage, @JsonProperty(value="blobs") List<GoogleBlob> blobs, @JsonProperty(value="maxCacheCapacityBytes") Long maxCacheCapacityBytes, @JsonProperty(value="maxFetchCapacityBytes") Long maxFetchCapacityBytes, @JsonProperty(value="prefetchTriggerBytes") Long prefetchTriggerBytes, @JsonProperty(value="fetchTimeout") Long fetchTimeout, @JsonProperty(value="maxFetchRetry") Integer maxFetchRetry) {
        super(maxCacheCapacityBytes, maxFetchCapacityBytes, prefetchTriggerBytes, fetchTimeout, maxFetchRetry);
        this.storage = storage;
        this.blobs = blobs;
    }

    @JsonProperty
    public List<GoogleBlob> getBlobs() {
        return this.blobs;
    }

    protected Collection<GoogleBlob> initObjects() {
        return this.blobs;
    }

    protected InputStream openObjectStream(GoogleBlob object) throws IOException {
        return this.openObjectStream(object, 0L);
    }

    protected InputStream openObjectStream(GoogleBlob object, long start) throws IOException {
        return this.createGoogleByteSource(object).openStream(start);
    }

    private GoogleByteSource createGoogleByteSource(GoogleBlob object) {
        String bucket = object.getBucket();
        String path = StringUtils.maybeRemoveLeadingSlash((String)object.getPath());
        return new GoogleByteSource(this.storage, bucket, path);
    }

    protected InputStream wrapObjectStream(GoogleBlob object, InputStream stream) throws IOException {
        return CompressionUtils.decompress((InputStream)stream, (String)object.getPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        StaticGoogleBlobStoreFirehoseFactory that = (StaticGoogleBlobStoreFirehoseFactory)((Object)o);
        return Objects.equals(this.blobs, that.blobs) && this.getMaxCacheCapacityBytes() == that.getMaxCacheCapacityBytes() && this.getMaxFetchCapacityBytes() == that.getMaxFetchCapacityBytes() && this.getPrefetchTriggerBytes() == that.getPrefetchTriggerBytes() && this.getFetchTimeout() == that.getFetchTimeout() && this.getMaxFetchRetry() == that.getMaxFetchRetry();
    }

    public int hashCode() {
        return Objects.hash(this.blobs, this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry());
    }

    protected Predicate<Throwable> getRetryCondition() {
        return GoogleUtils::isRetryable;
    }

    public FiniteFirehoseFactory<StringInputRowParser, GoogleBlob> withSplit(InputSplit<GoogleBlob> split) {
        return new StaticGoogleBlobStoreFirehoseFactory(this.storage, Collections.singletonList(split.get()), this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry());
    }
}

