/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.client.http.HttpResponseException;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.google.GoogleAccountConfig;
import org.apache.druid.storage.google.GoogleInputDataConfig;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleUtils;
import org.apache.druid.timeline.DataSegment;

public class GoogleDataSegmentKiller
implements DataSegmentKiller {
    private static final Logger LOG = new Logger(GoogleDataSegmentKiller.class);
    private final GoogleStorage storage;
    private final GoogleAccountConfig accountConfig;
    private final GoogleInputDataConfig inputDataConfig;

    @Inject
    public GoogleDataSegmentKiller(GoogleStorage storage, GoogleAccountConfig accountConfig, GoogleInputDataConfig inputDataConfig) {
        this.storage = storage;
        this.accountConfig = accountConfig;
        this.inputDataConfig = inputDataConfig;
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        LOG.info("Killing segment [%s]", new Object[]{segment.getId()});
        Map loadSpec = segment.getLoadSpec();
        String bucket = MapUtils.getString((Map)loadSpec, (String)"bucket");
        String indexPath = MapUtils.getString((Map)loadSpec, (String)"path");
        String descriptorPath = DataSegmentKiller.descriptorPath((String)indexPath);
        try {
            this.deleteIfPresent(bucket, indexPath);
            this.deleteIfPresent(bucket, descriptorPath);
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, "Couldn't kill segment[%s]: [%s]", new Object[]{segment.getId(), e.getMessage()});
        }
    }

    private void deleteIfPresent(String bucket, String path) throws IOException {
        try {
            RetryUtils.retry(() -> {
                this.storage.delete(bucket, path);
                return null;
            }, GoogleUtils::isRetryable, (int)1, (int)5);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() != 404) {
                throw e;
            }
            LOG.debug("Already deleted: [%s] [%s]", new Object[]{bucket, path});
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new RE((Throwable)e, "Failed to delete [%s] [%s]", new Object[]{bucket, path});
        }
    }

    public void killAll() throws IOException {
        if (this.accountConfig.getBucket() == null || this.accountConfig.getPrefix() == null) {
            throw new ISE("Cannot delete all segment files from Google Deep Storage since druid.google.bucket and druid.google.prefix are not both set.", new Object[0]);
        }
        LOG.info("Deleting all segment files from gs location [bucket: '%s' prefix: '%s']", new Object[]{this.accountConfig.getBucket(), this.accountConfig.getPrefix()});
        try {
            GoogleUtils.deleteObjectsInPath(this.storage, this.inputDataConfig, this.accountConfig.getBucket(), this.accountConfig.getPrefix(), (Predicate<StorageObject>)Predicates.alwaysTrue());
        }
        catch (Exception e) {
            LOG.error("Error occurred while deleting task log files from gs. Error: %s", new Object[]{e.getMessage()});
            throw new IOException(e);
        }
    }
}

