/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.data.SearchableVersionedDataFinder;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.google.GoogleDataSegmentPuller;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleUtils;

public class GoogleTimestampVersionedDataFinder
extends GoogleDataSegmentPuller
implements SearchableVersionedDataFinder<URI> {
    private static final long MAX_LISTING_KEYS = 1000L;

    @Inject
    public GoogleTimestampVersionedDataFinder(GoogleStorage storage) {
        super(storage);
    }

    public URI getLatestVersion(URI descriptorBase, @Nullable Pattern pattern) {
        try {
            long mostRecent = Long.MIN_VALUE;
            URI latest = null;
            CloudObjectLocation baseLocation = new CloudObjectLocation(descriptorBase);
            Objects objects = (Objects)this.storage.list(baseLocation.getBucket()).setPrefix(baseLocation.getPath()).setMaxResults(Long.valueOf(1000L)).execute();
            for (StorageObject storageObject : objects.getItems()) {
                long latestModified;
                if (GoogleUtils.isDirectoryPlaceholder(storageObject)) continue;
                CloudObjectLocation objectLocation = new CloudObjectLocation(storageObject.getBucket(), storageObject.getName());
                String keyString = StringUtils.maybeRemoveLeadingSlash((String)storageObject.getName().substring(baseLocation.getPath().length()));
                if (pattern != null && !pattern.matcher(keyString).matches() || (latestModified = storageObject.getUpdated().getValue()) < mostRecent) continue;
                mostRecent = latestModified;
                latest = objectLocation.toUri("gs");
            }
            return latest;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

