/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.client.http.HttpResponseException;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.google.GoogleInputDataConfig;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.ObjectStorageIterator;

public class GoogleUtils {
    private static final Logger log = new Logger(GoogleUtils.class);
    public static final Predicate<Throwable> GOOGLE_RETRY = GoogleUtils::isRetryable;

    public static boolean isRetryable(Throwable t) {
        if (t instanceof HttpResponseException) {
            HttpResponseException e = (HttpResponseException)t;
            return e.getStatusCode() == 429 || e.getStatusCode() / 500 == 1;
        }
        return t instanceof IOException;
    }

    static <T> T retryGoogleCloudStorageOperation(RetryUtils.Task<T> f) throws Exception {
        return (T)RetryUtils.retry(f, GOOGLE_RETRY, (int)10);
    }

    public static URI objectToUri(StorageObject object) {
        return GoogleUtils.objectToCloudObjectLocation(object).toUri("gs");
    }

    public static CloudObjectLocation objectToCloudObjectLocation(StorageObject object) {
        return new CloudObjectLocation(object.getBucket(), object.getName());
    }

    public static Iterator<StorageObject> lazyFetchingStorageObjectsIterator(GoogleStorage storage, Iterator<URI> uris, long maxListingLength) {
        return new ObjectStorageIterator(storage, uris, maxListingLength);
    }

    public static void deleteObjectsInPath(GoogleStorage storage, GoogleInputDataConfig config, String bucket, String prefix, Predicate<StorageObject> filter) throws Exception {
        Iterator<StorageObject> iterator = GoogleUtils.lazyFetchingStorageObjectsIterator(storage, (Iterator<URI>)ImmutableList.of((Object)new CloudObjectLocation(bucket, prefix).toUri("gs")).iterator(), config.getMaxListingLength());
        while (iterator.hasNext()) {
            StorageObject nextObject = iterator.next();
            if (!filter.apply((Object)nextObject)) continue;
            GoogleUtils.retryGoogleCloudStorageOperation(() -> {
                storage.delete(nextObject.getBucket(), nextObject.getName());
                return null;
            });
        }
    }

    public static boolean isDirectoryPlaceholder(StorageObject storageObject) {
        if (storageObject.getName().endsWith("/") && storageObject.getSize().intValue() == 0) {
            return true;
        }
        return storageObject.getName().endsWith("_$folder$") && storageObject.getSize().intValue() == 0;
    }
}

