/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleUtils;

public class ObjectStorageIterator
implements Iterator<StorageObject> {
    private final GoogleStorage storage;
    private final Iterator<URI> uris;
    private final long maxListingLength;
    private Storage.Objects.List listRequest;
    private Objects results;
    private URI currentUri;
    private String nextPageToken;
    private Iterator<StorageObject> storageObjectsIterator;
    private StorageObject currentObject;

    public ObjectStorageIterator(GoogleStorage storage, Iterator<URI> uris, long maxListingLength) {
        this.storage = storage;
        this.uris = uris;
        this.maxListingLength = maxListingLength;
        this.nextPageToken = null;
        this.prepareNextRequest();
        this.fetchNextBatch();
        this.advanceStorageObject();
    }

    private void prepareNextRequest() {
        try {
            this.currentUri = this.uris.next();
            String currentBucket = this.currentUri.getAuthority();
            String currentPrefix = StringUtils.maybeRemoveLeadingSlash((String)this.currentUri.getPath());
            this.nextPageToken = null;
            this.listRequest = this.storage.list(currentBucket).setPrefix(currentPrefix).setMaxResults(Long.valueOf(this.maxListingLength));
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    private void fetchNextBatch() {
        try {
            this.listRequest.setPageToken(this.nextPageToken);
            this.results = (Objects)GoogleUtils.retryGoogleCloudStorageOperation(() -> (Objects)this.listRequest.execute());
            this.storageObjectsIterator = this.results.getItems().iterator();
            this.nextPageToken = this.results.getNextPageToken();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentObject != null;
    }

    @Override
    public StorageObject next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        StorageObject retVal = this.currentObject;
        this.advanceStorageObject();
        return retVal;
    }

    private void advanceStorageObject() {
        while (this.storageObjectsIterator.hasNext() || this.nextPageToken != null || this.uris.hasNext()) {
            while (this.storageObjectsIterator.hasNext()) {
                StorageObject next = this.storageObjectsIterator.next();
                if (next.getName().endsWith("/") || next.getSize().signum() <= 0) continue;
                this.currentObject = next;
                return;
            }
            if (this.nextPageToken != null) {
                this.fetchNextBatch();
                continue;
            }
            if (!this.uris.hasNext()) continue;
            this.prepareNextRequest();
            this.fetchNextBatch();
        }
        this.currentObject = null;
    }
}

