/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.HistogramAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

@JsonTypeName(value="customBuckets")
public class CustomBucketsPostAggregator
extends ApproximateHistogramPostAggregator {
    private final float[] breaks;

    @JsonCreator
    public CustomBucketsPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="breaks") float[] breaks) {
        super(name, fieldName);
        this.breaks = breaks;
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        ApproximateHistogram ah = (ApproximateHistogram)values.get(this.fieldName);
        return ah.toHistogram(this.breaks);
    }

    public ColumnType getType(ColumnInspector signature) {
        return HistogramAggregatorFactory.TYPE;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public float[] getBreaks() {
        return this.breaks;
    }

    @Override
    public String toString() {
        return "CustomBucketsPostAggregator{name='" + this.getName() + '\'' + ", fieldName='" + this.getFieldName() + '\'' + ", breaks=" + Arrays.toString(this.getBreaks()) + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(11).appendString(this.fieldName).appendFloatArray(this.breaks).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomBucketsPostAggregator that = (CustomBucketsPostAggregator)o;
        return Arrays.equals(this.breaks, that.breaks);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.breaks);
        return result;
    }
}

