/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.google.common.base.Supplier;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Rows;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramAggregator;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class ApproximateHistogramFoldingSerde
extends ComplexMetricSerde {
    public String getTypeName() {
        return "approximateHistogram";
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<ApproximateHistogram> extractedClass() {
                return ApproximateHistogram.class;
            }

            public ApproximateHistogram extractValue(InputRow inputRow, String metricName) {
                Object rawValue = inputRow.getRaw(metricName);
                if (rawValue == null) {
                    return new ApproximateHistogram(0);
                }
                if (rawValue instanceof ApproximateHistogram) {
                    return (ApproximateHistogram)rawValue;
                }
                ApproximateHistogram h = new ApproximateHistogram();
                if (rawValue instanceof Collection) {
                    for (Object next : (Collection)rawValue) {
                        if (next == null) continue;
                        h.offer(Rows.objectToNumber((String)metricName, next, (boolean)true).floatValue());
                    }
                } else {
                    h.offer(Rows.objectToNumber((String)metricName, (Object)rawValue, (boolean)true).floatValue());
                }
                return h;
            }
        };
    }

    public void deserializeColumn(ByteBuffer byteBuffer, ColumnBuilder columnBuilder) {
        GenericIndexed column = GenericIndexed.read((ByteBuffer)byteBuffer, this.getObjectStrategy(), (SmooshedFileMapper)columnBuilder.getFileMapper());
        columnBuilder.setComplexColumnSupplier((Supplier)new ComplexColumnPartSupplier(this.getTypeName(), column));
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create((SegmentWriteOutMedium)segmentWriteOutMedium, (String)column, this.getObjectStrategy());
    }

    public ObjectStrategy<ApproximateHistogram> getObjectStrategy() {
        return new ObjectStrategy<ApproximateHistogram>(){

            public Class<ApproximateHistogram> getClazz() {
                return ApproximateHistogram.class;
            }

            public ApproximateHistogram fromByteBuffer(ByteBuffer buffer, int numBytes) {
                buffer.limit(buffer.position() + numBytes);
                return ApproximateHistogram.fromBytes(buffer);
            }

            public byte[] toBytes(ApproximateHistogram h) {
                if (h == null) {
                    return ByteArrays.EMPTY_ARRAY;
                }
                return h.toBytes();
            }

            public int compare(ApproximateHistogram o1, ApproximateHistogram o2) {
                return ApproximateHistogramAggregator.COMPARATOR.compare(o1, o2);
            }
        };
    }
}

