/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramAggregatorFactory;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramFoldingAggregatorFactory;
import org.apache.druid.query.aggregation.histogram.QuantilePostAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class QuantileSqlAggregator
implements SqlAggregator {
    private static final SqlAggFunction FUNCTION_INSTANCE = new QuantileSqlAggFunction();
    private static final String NAME = "APPROX_QUANTILE";

    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        ApproximateHistogramAggregatorFactory aggregatorFactory;
        int resolution;
        DruidExpression input = Aggregations.toDruidExpressionForNumericAggregator((PlannerContext)plannerContext, (RowSignature)rowSignature, (RexNode)Expressions.fromFieldAccess((RelDataTypeFactory)rexBuilder.getTypeFactory(), (RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(0))));
        if (input == null) {
            return null;
        }
        String histogramName = StringUtils.format((String)"%s:agg", (Object[])new Object[]{name});
        RexNode probabilityArg = Expressions.fromFieldAccess((RelDataTypeFactory)rexBuilder.getTypeFactory(), (RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(1)));
        if (!probabilityArg.isA(SqlKind.LITERAL)) {
            return null;
        }
        float probability = ((Number)((Object)RexLiteral.value((RexNode)probabilityArg))).floatValue();
        if (aggregateCall.getArgList().size() >= 3) {
            RexNode resolutionArg = Expressions.fromFieldAccess((RelDataTypeFactory)rexBuilder.getTypeFactory(), (RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(2)));
            if (!resolutionArg.isA(SqlKind.LITERAL)) {
                return null;
            }
            resolution = ((Number)((Object)RexLiteral.value((RexNode)resolutionArg))).intValue();
        } else {
            resolution = 50;
        }
        int numBuckets = 7;
        float lowerLimit = Float.NEGATIVE_INFINITY;
        float upperLimit = Float.POSITIVE_INFINITY;
        for (Aggregation existing : existingAggregations) {
            for (AggregatorFactory factory : existing.getAggregatorFactories()) {
                ApproximateHistogramAggregatorFactory theFactory;
                DruidExpression virtualInput;
                boolean inputMatches;
                boolean matches;
                if (!(factory instanceof ApproximateHistogramAggregatorFactory) || !(matches = (inputMatches = (virtualInput = (DruidExpression)virtualColumnRegistry.findVirtualColumnExpressions((theFactory = (ApproximateHistogramAggregatorFactory)factory).requiredFields()).stream().findFirst().orElse(null)) == null ? input.isDirectColumnAccess() && input.getDirectColumn().equals(theFactory.getFieldName()) : virtualInput.equals((Object)input)) && theFactory.getResolution() == resolution && theFactory.getNumBuckets() == 7 && theFactory.getLowerLimit() == Float.NEGATIVE_INFINITY && theFactory.getUpperLimit() == Float.POSITIVE_INFINITY)) continue;
                return Aggregation.create((List)ImmutableList.of(), (PostAggregator)new QuantilePostAggregator(name, factory.getName(), probability));
            }
        }
        if (input.isDirectColumnAccess()) {
            aggregatorFactory = rowSignature.getColumnType(input.getDirectColumn()).map(type -> type.is((TypeDescriptor)ValueType.COMPLEX)).orElse(false).booleanValue() ? new ApproximateHistogramFoldingAggregatorFactory(histogramName, input.getDirectColumn(), resolution, 7, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), false) : new ApproximateHistogramAggregatorFactory(histogramName, input.getDirectColumn(), resolution, 7, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), false);
        } else {
            String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(input, ColumnType.FLOAT);
            aggregatorFactory = new ApproximateHistogramAggregatorFactory(histogramName, virtualColumnName, resolution, 7, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), false);
        }
        return Aggregation.create((List)ImmutableList.of((Object)((Object)aggregatorFactory)), (PostAggregator)new QuantilePostAggregator(name, histogramName, probability));
    }

    private static class QuantileSqlAggFunction
    extends SqlAggFunction {
        private static final String SIGNATURE1 = "'APPROX_QUANTILE(column, probability)'";
        private static final String SIGNATURE2 = "'APPROX_QUANTILE(column, probability, resolution)'";

        QuantileSqlAggFunction() {
            super(QuantileSqlAggregator.NAME, null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE), null, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)SIGNATURE1, (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC})}), OperandTypes.and((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)SIGNATURE2, (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.LITERAL, OperandTypes.LITERAL}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.EXACT_NUMERIC})})}), SqlFunctionCategory.NUMERIC, false, false);
        }
    }
}

