/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.data.input.kafka.KafkaRecordEntity;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.kafka.KafkaDataSourceMetadata;
import org.apache.druid.indexing.kafka.KafkaIndexTask;
import org.apache.druid.indexing.kafka.KafkaIndexTaskClientFactory;
import org.apache.druid.indexing.kafka.KafkaIndexTaskIOConfig;
import org.apache.druid.indexing.kafka.KafkaIndexTaskTuningConfig;
import org.apache.druid.indexing.kafka.KafkaRecordSupplier;
import org.apache.druid.indexing.kafka.KafkaSequenceNumber;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorIOConfig;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorReportPayload;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorSpec;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorTuningConfig;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.LagStats;
import org.apache.druid.indexing.seekablestream.SeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTask;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClientFactory;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskIOConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskTuningConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;
import org.apache.druid.indexing.seekablestream.common.OrderedSequenceNumber;
import org.apache.druid.indexing.seekablestream.common.RecordSupplier;
import org.apache.druid.indexing.seekablestream.common.StreamException;
import org.apache.druid.indexing.seekablestream.common.StreamPartition;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisor;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIOConfig;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorReportPayload;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.server.metrics.DruidMonitorSchedulerConfig;
import org.joda.time.DateTime;

public class KafkaSupervisor
extends SeekableStreamSupervisor<Integer, Long, KafkaRecordEntity> {
    public static final TypeReference<TreeMap<Integer, Map<Integer, Long>>> CHECKPOINTS_TYPE_REF = new TypeReference<TreeMap<Integer, Map<Integer, Long>>>(){};
    private static final EmittingLogger log = new EmittingLogger(KafkaSupervisor.class);
    private static final Long NOT_SET = -1L;
    private static final Long END_OF_PARTITION = Long.MAX_VALUE;
    private final ServiceEmitter emitter;
    private final DruidMonitorSchedulerConfig monitorSchedulerConfig;
    private volatile Map<Integer, Long> latestSequenceFromStream;
    private final KafkaSupervisorSpec spec;

    public KafkaSupervisor(TaskStorage taskStorage, TaskMaster taskMaster, IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, KafkaIndexTaskClientFactory taskClientFactory, ObjectMapper mapper, KafkaSupervisorSpec spec, RowIngestionMetersFactory rowIngestionMetersFactory) {
        super(StringUtils.format((String)"KafkaSupervisor-%s", (Object[])new Object[]{spec.getDataSchema().getDataSource()}), taskStorage, taskMaster, indexerMetadataStorageCoordinator, (SeekableStreamIndexTaskClientFactory)taskClientFactory, mapper, (SeekableStreamSupervisorSpec)spec, rowIngestionMetersFactory, false);
        this.spec = spec;
        this.emitter = spec.getEmitter();
        this.monitorSchedulerConfig = spec.getMonitorSchedulerConfig();
    }

    protected RecordSupplier<Integer, Long, KafkaRecordEntity> setupRecordSupplier() {
        return new KafkaRecordSupplier(this.spec.getIoConfig().getConsumerProperties(), this.sortingMapper);
    }

    protected int getTaskGroupIdForPartition(Integer partitionId) {
        return partitionId % this.spec.getIoConfig().getTaskCount();
    }

    protected boolean checkSourceMetadataMatch(DataSourceMetadata metadata) {
        return metadata instanceof KafkaDataSourceMetadata;
    }

    protected boolean doesTaskTypeMatchSupervisor(Task task) {
        return task instanceof KafkaIndexTask;
    }

    protected SeekableStreamSupervisorReportPayload<Integer, Long> createReportPayload(int numPartitions, boolean includeOffsets) {
        KafkaSupervisorIOConfig ioConfig = this.spec.getIoConfig();
        Map<Integer, Long> partitionLag = this.getRecordLagPerPartition(this.getHighestCurrentOffsets());
        return new KafkaSupervisorReportPayload(this.spec.getDataSchema().getDataSource(), ioConfig.getTopic(), numPartitions, ioConfig.getReplicas(), ioConfig.getTaskDuration().getMillis() / 1000L, includeOffsets ? this.latestSequenceFromStream : null, includeOffsets ? partitionLag : null, includeOffsets ? Long.valueOf(partitionLag.values().stream().mapToLong(x -> Math.max(x, 0L)).sum()) : null, includeOffsets ? this.sequenceLastUpdated : null, this.spec.isSuspended(), this.stateManager.isHealthy(), this.stateManager.getSupervisorState().getBasicState(), this.stateManager.getSupervisorState(), this.stateManager.getExceptionEvents());
    }

    protected SeekableStreamIndexTaskIOConfig createTaskIoConfig(int groupId, Map<Integer, Long> startPartitions, Map<Integer, Long> endPartitions, String baseSequenceName, DateTime minimumMessageTime, DateTime maximumMessageTime, Set<Integer> exclusiveStartSequenceNumberPartitions, SeekableStreamSupervisorIOConfig ioConfig) {
        KafkaSupervisorIOConfig kafkaIoConfig = (KafkaSupervisorIOConfig)ioConfig;
        return new KafkaIndexTaskIOConfig(groupId, baseSequenceName, (SeekableStreamStartSequenceNumbers<Integer, Long>)new SeekableStreamStartSequenceNumbers(kafkaIoConfig.getTopic(), startPartitions, Collections.emptySet()), (SeekableStreamEndSequenceNumbers<Integer, Long>)new SeekableStreamEndSequenceNumbers(kafkaIoConfig.getTopic(), endPartitions), kafkaIoConfig.getConsumerProperties(), kafkaIoConfig.getPollTimeout(), true, minimumMessageTime, maximumMessageTime, ioConfig.getInputFormat());
    }

    protected List<SeekableStreamIndexTask<Integer, Long, KafkaRecordEntity>> createIndexTasks(int replicas, String baseSequenceName, ObjectMapper sortingMapper, TreeMap<Integer, Map<Integer, Long>> sequenceOffsets, SeekableStreamIndexTaskIOConfig taskIoConfig, SeekableStreamIndexTaskTuningConfig taskTuningConfig, RowIngestionMetersFactory rowIngestionMetersFactory) throws JsonProcessingException {
        String checkpoints = sortingMapper.writerFor(CHECKPOINTS_TYPE_REF).writeValueAsString(sequenceOffsets);
        Map context = this.createBaseTaskContexts();
        context.put("checkpoints", checkpoints);
        context.put("IS_INCREMENTAL_HANDOFF_SUPPORTED", true);
        ArrayList<SeekableStreamIndexTask<Integer, Long, KafkaRecordEntity>> taskList = new ArrayList<SeekableStreamIndexTask<Integer, Long, KafkaRecordEntity>>();
        for (int i = 0; i < replicas; ++i) {
            String taskId = IdUtils.getRandomIdWithPrefix((String)baseSequenceName);
            taskList.add(new KafkaIndexTask(taskId, new TaskResource(baseSequenceName, 1), this.spec.getDataSchema(), (KafkaIndexTaskTuningConfig)taskTuningConfig, (KafkaIndexTaskIOConfig)taskIoConfig, context, sortingMapper));
        }
        return taskList;
    }

    protected Map<Integer, Long> getPartitionRecordLag() {
        Map highestCurrentOffsets = this.getHighestCurrentOffsets();
        if (this.latestSequenceFromStream == null) {
            return null;
        }
        if (!this.latestSequenceFromStream.keySet().equals(highestCurrentOffsets.keySet())) {
            log.warn("Lag metric: Kafka partitions %s do not match task partitions %s", new Object[]{this.latestSequenceFromStream.keySet(), highestCurrentOffsets.keySet()});
        }
        return this.getRecordLagPerPartition(highestCurrentOffsets);
    }

    @Nullable
    protected Map<Integer, Long> getPartitionTimeLag() {
        return null;
    }

    protected Map<Integer, Long> getRecordLagPerPartition(Map<Integer, Long> currentOffsets) {
        return currentOffsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.latestSequenceFromStream != null && this.latestSequenceFromStream.get(e.getKey()) != null && e.getValue() != null ? this.latestSequenceFromStream.get(e.getKey()) - (Long)e.getValue() : Integer.MIN_VALUE));
    }

    protected Map<Integer, Long> getTimeLagPerPartition(Map<Integer, Long> currentOffsets) {
        return null;
    }

    protected KafkaDataSourceMetadata createDataSourceMetaDataForReset(String topic, Map<Integer, Long> map) {
        return new KafkaDataSourceMetadata((SeekableStreamSequenceNumbers<Integer, Long>)new SeekableStreamEndSequenceNumbers(topic, map));
    }

    protected OrderedSequenceNumber<Long> makeSequenceNumber(Long seq, boolean isExclusive) {
        return KafkaSequenceNumber.of(seq);
    }

    protected Long getNotSetMarker() {
        return NOT_SET;
    }

    protected Long getEndOfPartitionMarker() {
        return END_OF_PARTITION;
    }

    protected boolean isEndOfShard(Long seqNum) {
        return false;
    }

    protected boolean isShardExpirationMarker(Long seqNum) {
        return false;
    }

    protected boolean useExclusiveStartSequenceNumberForNonFirstSequence() {
        return false;
    }

    public LagStats computeLagStats() {
        Map<Integer, Long> partitionRecordLag = this.getPartitionRecordLag();
        if (partitionRecordLag == null) {
            return new LagStats(0L, 0L, 0L);
        }
        return this.computeLags(partitionRecordLag);
    }

    protected void updatePartitionLagFromStream() {
        this.getRecordSupplierLock().lock();
        try {
            Set partitionIds;
            try {
                partitionIds = this.recordSupplier.getPartitionIds(this.getIoConfig().getStream());
            }
            catch (Exception e2) {
                log.warn("Could not fetch partitions for topic/stream [%s]", new Object[]{this.getIoConfig().getStream()});
                throw new StreamException((Throwable)e2);
            }
            Set partitions = partitionIds.stream().map(e -> new StreamPartition(this.getIoConfig().getStream(), e)).collect(Collectors.toSet());
            this.recordSupplier.seekToLatest(partitions);
            this.latestSequenceFromStream = partitions.stream().collect(Collectors.toMap(StreamPartition::getPartitionId, arg_0 -> ((RecordSupplier)this.recordSupplier).getPosition(arg_0)));
        }
        catch (InterruptedException e3) {
            throw new StreamException((Throwable)e3);
        }
        finally {
            this.getRecordSupplierLock().unlock();
        }
    }

    protected String baseTaskName() {
        return "index_kafka";
    }

    @VisibleForTesting
    public KafkaSupervisorIOConfig getIoConfig() {
        return this.spec.getIoConfig();
    }

    @VisibleForTesting
    public KafkaSupervisorTuningConfig getTuningConfig() {
        return this.spec.getTuningConfig();
    }
}

