/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskTuningConfig;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Period;

@JsonTypeName(value="KinesisTuningConfig")
public class KinesisIndexTaskTuningConfig
extends SeekableStreamIndexTaskTuningConfig {
    private static final int DEFAULT_RECORD_BUFFER_SIZE = 10000;
    private static final int DEFAULT_RECORD_BUFFER_OFFER_TIMEOUT = 5000;
    private static final int DEFAULT_RECORD_BUFFER_FULL_WAIT = 5000;
    private static final int DEFAULT_FETCH_SEQUENCE_NUMBER_TIMEOUT = 20000;
    private static final int DEFAULT_MAX_RECORDS_PER_POLL = 100;
    private final int recordBufferSize;
    private final int recordBufferOfferTimeout;
    private final int recordBufferFullWait;
    private final int fetchSequenceNumberTimeout;
    private final Integer fetchThreads;
    private final int maxRecordsPerPoll;

    @JsonCreator
    public KinesisIndexTaskTuningConfig(@JsonProperty(value="appendableIndexSpec") @Nullable AppendableIndexSpec appendableIndexSpec, @JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") Long maxBytesInMemory, @JsonProperty(value="skipBytesInMemoryOverheadCheck") @Nullable Boolean skipBytesInMemoryOverheadCheck, @JsonProperty(value="maxRowsPerSegment") Integer maxRowsPerSegment, @JsonProperty(value="maxTotalRows") Long maxTotalRows, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") Long handoffConditionTimeout, @JsonProperty(value="resetOffsetAutomatically") Boolean resetOffsetAutomatically, @JsonProperty(value="skipSequenceNumberAvailabilityCheck") Boolean skipSequenceNumberAvailabilityCheck, @JsonProperty(value="recordBufferSize") Integer recordBufferSize, @JsonProperty(value="recordBufferOfferTimeout") Integer recordBufferOfferTimeout, @JsonProperty(value="recordBufferFullWait") Integer recordBufferFullWait, @JsonProperty(value="fetchSequenceNumberTimeout") Integer fetchSequenceNumberTimeout, @JsonProperty(value="fetchThreads") Integer fetchThreads, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions, @JsonProperty(value="maxRecordsPerPoll") @Nullable Integer maxRecordsPerPoll, @JsonProperty(value="intermediateHandoffPeriod") @Nullable Period intermediateHandoffPeriod) {
        super(appendableIndexSpec, maxRowsInMemory, maxBytesInMemory, skipBytesInMemoryOverheadCheck, maxRowsPerSegment, maxTotalRows, intermediatePersistPeriod, basePersistDirectory, maxPendingPersists, indexSpec, indexSpecForIntermediatePersists, reportParseExceptions, handoffConditionTimeout, resetOffsetAutomatically, skipSequenceNumberAvailabilityCheck, segmentWriteOutMediumFactory, intermediateHandoffPeriod, logParseExceptions, maxParseExceptions, maxSavedParseExceptions);
        this.recordBufferSize = recordBufferSize == null ? 10000 : recordBufferSize;
        this.recordBufferOfferTimeout = recordBufferOfferTimeout == null ? 5000 : recordBufferOfferTimeout;
        this.recordBufferFullWait = recordBufferFullWait == null ? 5000 : recordBufferFullWait;
        this.fetchSequenceNumberTimeout = fetchSequenceNumberTimeout == null ? 20000 : fetchSequenceNumberTimeout;
        this.fetchThreads = fetchThreads;
        this.maxRecordsPerPoll = maxRecordsPerPoll == null ? 100 : maxRecordsPerPoll;
        Preconditions.checkArgument((!super.isResetOffsetAutomatically() || !super.isSkipSequenceNumberAvailabilityCheck() ? 1 : 0) != 0, (Object)"resetOffsetAutomatically cannot be used if skipSequenceNumberAvailabilityCheck=true");
    }

    @JsonProperty
    public int getRecordBufferSize() {
        return this.recordBufferSize;
    }

    @JsonProperty
    public int getRecordBufferOfferTimeout() {
        return this.recordBufferOfferTimeout;
    }

    @JsonProperty
    public int getRecordBufferFullWait() {
        return this.recordBufferFullWait;
    }

    @JsonProperty
    public int getFetchSequenceNumberTimeout() {
        return this.fetchSequenceNumberTimeout;
    }

    @JsonProperty
    public Integer getFetchThreads() {
        return this.fetchThreads;
    }

    @JsonProperty
    public int getMaxRecordsPerPoll() {
        return this.maxRecordsPerPoll;
    }

    public KinesisIndexTaskTuningConfig withBasePersistDirectory(File dir) {
        return new KinesisIndexTaskTuningConfig(this.getAppendableIndexSpec(), this.getMaxRowsInMemory(), this.getMaxBytesInMemory(), this.isSkipBytesInMemoryOverheadCheck(), this.getMaxRowsPerSegment(), this.getMaxTotalRows(), this.getIntermediatePersistPeriod(), dir, this.getMaxPendingPersists(), this.getIndexSpec(), this.getIndexSpecForIntermediatePersists(), this.isReportParseExceptions(), this.getHandoffConditionTimeout(), this.isResetOffsetAutomatically(), this.isSkipSequenceNumberAvailabilityCheck(), this.getRecordBufferSize(), this.getRecordBufferOfferTimeout(), this.getRecordBufferFullWait(), this.getFetchSequenceNumberTimeout(), this.getFetchThreads(), this.getSegmentWriteOutMediumFactory(), this.isLogParseExceptions(), this.getMaxParseExceptions(), this.getMaxSavedParseExceptions(), this.getMaxRecordsPerPoll(), this.getIntermediateHandoffPeriod());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KinesisIndexTaskTuningConfig that = (KinesisIndexTaskTuningConfig)((Object)o);
        return this.recordBufferSize == that.recordBufferSize && this.recordBufferOfferTimeout == that.recordBufferOfferTimeout && this.recordBufferFullWait == that.recordBufferFullWait && this.fetchSequenceNumberTimeout == that.fetchSequenceNumberTimeout && this.maxRecordsPerPoll == that.maxRecordsPerPoll && Objects.equals(this.fetchThreads, that.fetchThreads);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.recordBufferSize, this.recordBufferOfferTimeout, this.recordBufferFullWait, this.fetchSequenceNumberTimeout, this.fetchThreads, this.maxRecordsPerPoll);
    }

    public String toString() {
        return "KinesisIndexTaskTuningConfig{maxRowsInMemory=" + this.getMaxRowsInMemory() + ", maxBytesInMemory=" + this.getMaxBytesInMemory() + ", skipBytesInMemoryOverheadCheck=" + this.isSkipBytesInMemoryOverheadCheck() + ", maxRowsPerSegment=" + this.getMaxRowsPerSegment() + ", maxTotalRows=" + this.getMaxTotalRows() + ", intermediatePersistPeriod=" + this.getIntermediatePersistPeriod() + ", basePersistDirectory=" + this.getBasePersistDirectory() + ", maxPendingPersists=" + this.getMaxPendingPersists() + ", indexSpec=" + this.getIndexSpec() + ", reportParseExceptions=" + this.isReportParseExceptions() + ", handoffConditionTimeout=" + this.getHandoffConditionTimeout() + ", resetOffsetAutomatically=" + this.isResetOffsetAutomatically() + ", skipSequenceNumberAvailabilityCheck=" + this.isSkipSequenceNumberAvailabilityCheck() + ", recordBufferSize=" + this.recordBufferSize + ", recordBufferOfferTimeout=" + this.recordBufferOfferTimeout + ", recordBufferFullWait=" + this.recordBufferFullWait + ", fetchSequenceNumberTimeout=" + this.fetchSequenceNumberTimeout + ", fetchThreads=" + this.fetchThreads + ", segmentWriteOutMediumFactory=" + this.getSegmentWriteOutMediumFactory() + ", logParseExceptions=" + this.isLogParseExceptions() + ", maxParseExceptions=" + this.getMaxParseExceptions() + ", maxSavedParseExceptions=" + this.getMaxSavedParseExceptions() + ", maxRecordsPerPoll=" + this.maxRecordsPerPoll + ", intermediateHandoffPeriod=" + this.getIntermediateHandoffPeriod() + '}';
    }
}

