/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.inject.name.Named;
import javax.annotation.Nullable;
import org.apache.druid.common.aws.AWSCredentialsConfig;
import org.apache.druid.indexing.kinesis.KinesisRecordSupplier;
import org.apache.druid.indexing.kinesis.supervisor.KinesisSupervisorIOConfig;
import org.apache.druid.indexing.kinesis.supervisor.KinesisSupervisorSpec;
import org.apache.druid.indexing.kinesis.supervisor.KinesisSupervisorTuningConfig;
import org.apache.druid.indexing.overlord.sampler.InputSourceSampler;
import org.apache.druid.indexing.overlord.sampler.SamplerConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamSamplerSpec;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorSpec;

public class KinesisSamplerSpec
extends SeekableStreamSamplerSpec {
    private final AWSCredentialsConfig awsCredentialsConfig;

    @JsonCreator
    public KinesisSamplerSpec(@JsonProperty(value="spec") KinesisSupervisorSpec ingestionSpec, @JsonProperty(value="samplerConfig") @Nullable SamplerConfig samplerConfig, @JacksonInject InputSourceSampler inputSourceSampler, @JacksonInject @Named(value="kinesis") AWSCredentialsConfig awsCredentialsConfig) {
        super((SeekableStreamSupervisorSpec)ingestionSpec, samplerConfig, inputSourceSampler);
        this.awsCredentialsConfig = awsCredentialsConfig;
    }

    protected KinesisRecordSupplier createRecordSupplier() {
        KinesisSupervisorIOConfig ioConfig = (KinesisSupervisorIOConfig)this.ioConfig;
        KinesisSupervisorTuningConfig tuningConfig = (KinesisSupervisorTuningConfig)this.tuningConfig;
        return new KinesisRecordSupplier(KinesisRecordSupplier.getAmazonKinesisClient(ioConfig.getEndpoint(), this.awsCredentialsConfig, ioConfig.getAwsAssumedRoleArn(), ioConfig.getAwsExternalId()), ioConfig.getRecordsPerFetch(), ioConfig.getFetchDelayMillis(), 1, ioConfig.isDeaggregate(), tuningConfig.getRecordBufferSize(), tuningConfig.getRecordBufferOfferTimeout(), tuningConfig.getRecordBufferFullWait(), tuningConfig.getFetchSequenceNumberTimeout(), tuningConfig.getMaxRecordsPerPoll(), ioConfig.isUseEarliestSequenceNumber());
    }
}

