/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteSource;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.Parser;

public class MapPopulator<K, V> {
    private static final Logger LOG = new Logger(MapPopulator.class);
    private static final String DOUBLE_CLASS_NAME = Double.class.getName();
    private static final String FLOAT_CLASS_NAME = Float.class.getName();
    private static final String INTEGER_CLASS_NAME = Integer.class.getName();
    private static final String LONG_CLASS_NAME = Long.class.getName();
    private static final String STRING_CLASS_NAME = String.class.getName();
    private final Parser<K, V> parser;

    public MapPopulator(Parser<K, V> parser) {
        this.parser = parser;
    }

    public PopulateResult populate(ByteSource source, Map<K, V> map) throws IOException {
        return this.populateAndWarnAtByteLimit(source, map, -1L, null);
    }

    public PopulateResult populateAndWarnAtByteLimit(ByteSource source, final Map<K, V> map, final long byteLimit, final String name) throws IOException {
        return (PopulateResult)source.asCharSource(StandardCharsets.UTF_8).readLines((LineProcessor)new LineProcessor<PopulateResult>(){
            private int lines = 0;
            private int entries = 0;
            private long bytes = 0L;
            private long byteLimitMultiple = 1L;
            private boolean keyAndValueByteSizesCanBeDetermined = true;

            public boolean processLine(String line) {
                if (this.lines == Integer.MAX_VALUE) {
                    throw new ISE("Cannot read more than %,d lines", new Object[]{Integer.MAX_VALUE});
                }
                Map kvMap = MapPopulator.this.parser.parseToMap(line);
                if (kvMap == null) {
                    return true;
                }
                map.putAll(kvMap);
                ++this.lines;
                this.entries += kvMap.size();
                if (0L < byteLimit && this.keyAndValueByteSizesCanBeDetermined) {
                    for (Map.Entry e : kvMap.entrySet()) {
                        this.keyAndValueByteSizesCanBeDetermined = MapPopulator.canKeyAndValueTypesByteSizesBeDetermined(e.getKey(), e.getValue());
                        if (!this.keyAndValueByteSizesCanBeDetermined) continue;
                        this.bytes += MapPopulator.getByteLengthOfObject(e.getKey());
                        this.bytes += MapPopulator.getByteLengthOfObject(e.getValue());
                        if (this.bytes <= byteLimit * this.byteLimitMultiple) continue;
                        LOG.warn("[%s] exceeded the byteLimit of [%,d]. Current bytes [%,d]", new Object[]{name, byteLimit, this.bytes});
                        ++this.byteLimitMultiple;
                    }
                }
                return true;
            }

            public PopulateResult getResult() {
                return new PopulateResult(this.lines, this.entries, this.bytes);
            }
        });
    }

    public static <K, V> PopulateResult populateAndWarnAtByteLimit(Iterator<Pair<K, V>> iterator, Map<K, V> map, long byteLimit, String name) {
        int lines = 0;
        int entries = 0;
        long bytes = 0L;
        long byteLimitMultiple = 1L;
        boolean keyAndValueByteSizesCanBeDetermined = true;
        while (iterator.hasNext()) {
            Pair<K, V> pair = iterator.next();
            Object lhs = null != pair ? pair.lhs : null;
            Object rhs = null != pair ? pair.rhs : null;
            map.put(lhs, rhs);
            ++entries;
            if (0L >= byteLimit || !keyAndValueByteSizesCanBeDetermined || !(keyAndValueByteSizesCanBeDetermined = MapPopulator.canKeyAndValueTypesByteSizesBeDetermined(lhs, rhs))) continue;
            bytes += MapPopulator.getByteLengthOfObject(lhs);
            if ((bytes += MapPopulator.getByteLengthOfObject(rhs)) <= byteLimit * byteLimitMultiple) continue;
            LOG.warn("[%s] exceeded the byteLimit of [%,d]. Current bytes [%,d]", new Object[]{name, byteLimit, bytes});
            ++byteLimitMultiple;
        }
        return new PopulateResult(lines, entries, bytes);
    }

    @VisibleForTesting
    static long getByteLengthOfObject(@Nullable Object o) {
        if (null != o) {
            if (o.getClass().getName().equals(STRING_CLASS_NAME)) {
                return ((String)o).length();
            }
            if (o.getClass().getName().equals(DOUBLE_CLASS_NAME)) {
                return 8L;
            }
            if (o.getClass().getName().equals(FLOAT_CLASS_NAME)) {
                return 4L;
            }
            if (o.getClass().getName().equals(INTEGER_CLASS_NAME)) {
                return 4L;
            }
            if (o.getClass().getName().equals(LONG_CLASS_NAME)) {
                return 8L;
            }
        }
        return 0L;
    }

    @VisibleForTesting
    static <K, V> boolean canKeyAndValueTypesByteSizesBeDetermined(@Nullable K key, @Nullable V value) {
        boolean canBeDetermined;
        boolean bl = canBeDetermined = !(null != key && !key.getClass().getName().equals(STRING_CLASS_NAME) && !key.getClass().getName().equals(DOUBLE_CLASS_NAME) && !key.getClass().getName().equals(FLOAT_CLASS_NAME) && !key.getClass().getName().equals(INTEGER_CLASS_NAME) && !key.getClass().getName().equals(LONG_CLASS_NAME) || null != value && !value.getClass().getName().equals(STRING_CLASS_NAME) && !value.getClass().getName().equals(DOUBLE_CLASS_NAME) && !value.getClass().getName().equals(FLOAT_CLASS_NAME) && !value.getClass().getName().equals(INTEGER_CLASS_NAME) && !value.getClass().getName().equals(LONG_CLASS_NAME));
        if (!canBeDetermined) {
            LOG.warn("cannot compute number of bytes when populating map because key and value classes are neither Double, Float, Integer, Long, or String. Key class: [%s], Value class: [%s]", new Object[]{null != key ? key.getClass().getName() : null, null != value ? value.getClass().getName() : null});
        }
        return canBeDetermined;
    }

    public static class PopulateResult {
        private final int lines;
        private final int entries;
        private final long bytes;

        public PopulateResult(int lines, int entries, long bytes) {
            this.lines = lines;
            this.entries = entries;
            this.bytes = bytes;
        }

        public int getLines() {
            return this.lines;
        }

        public int getEntries() {
            return this.entries;
        }

        public long getBytes() {
            return this.bytes;
        }
    }
}

