/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.druid.common.utils.ServletResourceUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupIntrospectHandler;
import org.apache.druid.query.lookup.NamespaceLookupExtractorFactory;
import org.apache.druid.server.lookup.namespace.cache.CacheScheduler;

public class NamespaceLookupIntrospectHandler
implements LookupIntrospectHandler {
    private final NamespaceLookupExtractorFactory factory;

    public NamespaceLookupIntrospectHandler(NamespaceLookupExtractorFactory factory) {
        this.factory = factory;
    }

    @GET
    @Path(value="/keys")
    @Produces(value={"application/json"})
    public Response getKeys() {
        try {
            return Response.ok(this.getLatest().keySet()).build();
        }
        catch (ISE e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @GET
    @Path(value="/values")
    @Produces(value={"application/json"})
    public Response getValues() {
        try {
            return Response.ok(this.getLatest().values()).build();
        }
        catch (ISE e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @GET
    @Path(value="/version")
    @Produces(value={"application/json"})
    public Response getVersion() {
        CacheScheduler.CacheState cacheState = this.factory.entry.getCacheState();
        if (cacheState instanceof CacheScheduler.NoCache) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String version = ((CacheScheduler.VersionedCache)cacheState).getVersion();
        return Response.ok((Object)ImmutableMap.of((Object)"version", (Object)version)).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getMap() {
        try {
            return Response.ok(this.getLatest()).build();
        }
        catch (ISE e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    private Map<String, String> getLatest() {
        return ((MapLookupExtractor)this.factory.get()).getMap();
    }
}

