/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.namespace;

import com.google.common.base.Strings;
import java.sql.Timestamp;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.namespace.CacheGenerator;
import org.apache.druid.query.lookup.namespace.JdbcExtractionNamespace;
import org.apache.druid.server.lookup.namespace.cache.CacheHandler;
import org.apache.druid.server.lookup.namespace.cache.CacheScheduler;
import org.apache.druid.utils.JvmUtils;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.TimestampMapper;

public final class JdbcCacheGenerator
implements CacheGenerator<JdbcExtractionNamespace> {
    private static final Logger LOG = new Logger(JdbcCacheGenerator.class);
    private static final String NO_SUITABLE_DRIVER_FOUND_ERROR = "No suitable driver found";
    private static final String JDBC_DRIVER_JAR_FILES_MISSING_ERROR = "JDBC driver JAR files missing from extensions/druid-lookups-cached-global directory";
    private static final long MAX_MEMORY = JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes();
    private final ConcurrentMap<CacheScheduler.EntryImpl<JdbcExtractionNamespace>, DBI> dbiCache = new ConcurrentHashMap<CacheScheduler.EntryImpl<JdbcExtractionNamespace>, DBI>();

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public String generateCache(JdbcExtractionNamespace namespace, CacheScheduler.EntryImpl<JdbcExtractionNamespace> entryId, String lastVersion, CacheHandler cache) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Handle getHandle(CacheScheduler.EntryImpl<JdbcExtractionNamespace> key, JdbcExtractionNamespace namespace) {
        DBI dbi = this.ensureDBI(key, namespace);
        return dbi.open();
    }

    private ResultIterator<Pair<String, String>> getLookupPairs(Handle handle, JdbcExtractionNamespace namespace) {
        String table = namespace.getTable();
        String filter = namespace.getFilter();
        String valueColumn = namespace.getValueColumn();
        String keyColumn = namespace.getKeyColumn();
        return handle.createQuery(JdbcCacheGenerator.buildLookupQuery(table, filter, keyColumn, valueColumn)).map((index1, r1, ctx1) -> new Pair((Object)r1.getString(keyColumn), (Object)r1.getString(valueColumn))).iterator();
    }

    private static String buildLookupQuery(String table, String filter, String keyColumn, String valueColumn) {
        if (Strings.isNullOrEmpty((String)filter)) {
            return StringUtils.format((String)"SELECT %s, %s FROM %s WHERE %s IS NOT NULL", (Object[])new Object[]{keyColumn, valueColumn, table, valueColumn});
        }
        return StringUtils.format((String)"SELECT %s, %s FROM %s WHERE %s AND %s IS NOT NULL", (Object[])new Object[]{keyColumn, valueColumn, table, filter, valueColumn});
    }

    private DBI ensureDBI(CacheScheduler.EntryImpl<JdbcExtractionNamespace> key, JdbcExtractionNamespace namespace) {
        DBI dbi = null;
        if (this.dbiCache.containsKey(key)) {
            dbi = (DBI)this.dbiCache.get(key);
        }
        if (dbi == null) {
            DBI newDbi = new DBI(namespace.getConnectorConfig().getConnectURI(), namespace.getConnectorConfig().getUser(), namespace.getConnectorConfig().getPassword());
            this.dbiCache.putIfAbsent(key, newDbi);
            dbi = (DBI)this.dbiCache.get(key);
        }
        return dbi;
    }

    @Nullable
    private Long lastUpdates(CacheScheduler.EntryImpl<JdbcExtractionNamespace> key, JdbcExtractionNamespace namespace) {
        DBI dbi = this.ensureDBI(key, namespace);
        String table = namespace.getTable();
        String tsColumn = namespace.getTsColumn();
        if (tsColumn == null) {
            return null;
        }
        Timestamp update = (Timestamp)dbi.withHandle(handle -> {
            String query = StringUtils.format((String)"SELECT MAX(%s) FROM %s", (Object[])new Object[]{tsColumn, table});
            return (Timestamp)handle.createQuery(query).map((ResultSetMapper)TimestampMapper.FIRST).first();
        });
        return update.getTime();
    }
}

