/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.namespace;

import com.google.common.base.Predicate;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.data.SearchableVersionedDataFinder;
import org.apache.druid.data.input.MapPopulator;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.namespace.CacheGenerator;
import org.apache.druid.query.lookup.namespace.UriExtractionNamespace;
import org.apache.druid.segment.loading.URIDataPuller;
import org.apache.druid.server.lookup.namespace.cache.CacheHandler;
import org.apache.druid.server.lookup.namespace.cache.CacheScheduler;
import org.apache.druid.utils.CompressionUtils;
import org.apache.druid.utils.JvmUtils;

public final class UriCacheGenerator
implements CacheGenerator<UriExtractionNamespace> {
    private static final int DEFAULT_NUM_RETRIES = 3;
    private static final Logger log = new Logger(UriCacheGenerator.class);
    private static final long MAX_MEMORY = JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes();
    private final Map<String, SearchableVersionedDataFinder> pullers;

    @Inject
    public UriCacheGenerator(Map<String, SearchableVersionedDataFinder> pullers) {
        this.pullers = pullers;
    }

    @Override
    @Nullable
    public String generateCache(UriExtractionNamespace extractionNamespace, CacheScheduler.EntryImpl<UriExtractionNamespace> entryId, @Nullable String lastVersion, CacheHandler cache) throws Exception {
        URI uri;
        boolean doSearch = extractionNamespace.getUriPrefix() != null;
        URI originalUri = doSearch ? extractionNamespace.getUriPrefix() : extractionNamespace.getUri();
        SearchableVersionedDataFinder pullerRaw = this.pullers.get(originalUri.getScheme());
        if (pullerRaw == null) {
            throw new IAE("Unknown loader type[%s].  Known types are %s", new Object[]{originalUri.getScheme(), this.pullers.keySet()});
        }
        if (!(pullerRaw instanceof URIDataPuller)) {
            throw new IAE("Cannot load data from location [%s]. Data pulling from [%s] not supported", new Object[]{originalUri, originalUri.getScheme()});
        }
        final URIDataPuller puller = (URIDataPuller)pullerRaw;
        if (doSearch) {
            Pattern versionRegex = extractionNamespace.getFileRegex() != null ? Pattern.compile(extractionNamespace.getFileRegex()) : null;
            uri = (URI)pullerRaw.getLatestVersion((Object)extractionNamespace.getUriPrefix(), versionRegex);
            if (uri == null) {
                throw new FileNotFoundException(StringUtils.format((String)"Could not find match for pattern `%s` in [%s] for %s", (Object[])new Object[]{versionRegex, originalUri, extractionNamespace}));
            }
        } else {
            uri = extractionNamespace.getUri();
        }
        return (String)RetryUtils.retry(() -> {
            String version = puller.getVersion(uri);
            try {
                if (version.equals(lastVersion)) {
                    log.debug("URI [%s] for [%s] has the same last modified time [%s] as the last cached. Skipping ", new Object[]{uri.toString(), entryId, version});
                    return null;
                }
            }
            catch (NumberFormatException ex) {
                log.debug((Throwable)ex, "Failed to get last modified timestamp. Assuming no timestamp", new Object[0]);
            }
            ByteSource source = new ByteSource(){

                public InputStream openStream() throws IOException {
                    return CompressionUtils.decompress((InputStream)puller.getInputStream(uri), (String)uri.getPath());
                }
            };
            try {
                long startNs = System.nanoTime();
                MapPopulator.PopulateResult populateResult = new MapPopulator<String, String>(extractionNamespace.getNamespaceParseSpec().getParser()).populateAndWarnAtByteLimit(source, cache.getCache(), (long)((double)(MAX_MEMORY * extractionNamespace.getMaxHeapPercentage()) / 100.0), null == entryId ? null : entryId.toString());
                long duration = System.nanoTime() - startNs;
                log.info("Finished loading %,d values (%d bytes) from %,d lines for [%s] in %,d ns", new Object[]{populateResult.getEntries(), populateResult.getBytes(), populateResult.getLines(), entryId, duration});
                return version;
            }
            catch (Throwable t) {
                try {
                    cache.close();
                }
                catch (Exception e) {
                    t.addSuppressed(e);
                }
                throw t;
            }
        }, (Predicate)puller.shouldRetryPredicate(), (int)3);
    }
}

