/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.namespace;

import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.druid.query.lookup.namespace.CacheGenerator;
import org.apache.druid.query.lookup.namespace.StaticMapExtractionNamespace;
import org.apache.druid.server.lookup.namespace.cache.CacheHandler;
import org.apache.druid.server.lookup.namespace.cache.CacheScheduler;

public final class StaticMapCacheGenerator
implements CacheGenerator<StaticMapExtractionNamespace> {
    private final String version = UUID.randomUUID().toString();

    @Override
    @Nullable
    public String generateCache(StaticMapExtractionNamespace namespace, CacheScheduler.EntryImpl<StaticMapExtractionNamespace> id, String lastVersion, CacheHandler cache) {
        if (lastVersion != null) {
            throw new AssertionError((Object)("StaticMapCacheGenerator could only be configured for a namespace which is scheduled to be updated once, not periodically. Last version: `" + lastVersion + "`"));
        }
        try {
            cache.getCache().putAll(namespace.getMap());
            return this.version;
        }
        catch (Throwable t) {
            try {
                cache.close();
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    String getVersion() {
        return this.version;
    }
}

