/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.namespace.cache;

import com.google.common.base.Throwables;
import com.google.common.collect.ForwardingConcurrentMap;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.java.util.common.Cleaners;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.server.lookup.namespace.NamespaceExtractionConfig;
import org.apache.druid.server.lookup.namespace.cache.CacheHandler;
import org.apache.druid.server.lookup.namespace.cache.NamespaceExtractionCacheManager;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;

public class OffHeapNamespaceExtractionCacheManager
extends NamespaceExtractionCacheManager {
    private static final Logger log = new Logger(OffHeapNamespaceExtractionCacheManager.class);
    private final DB mmapDB;
    private final File tmpFile;
    private AtomicLong mapDbKeyCounter = new AtomicLong(0L);
    private AtomicInteger cacheCount = new AtomicInteger(0);

    @Inject
    public OffHeapNamespaceExtractionCacheManager(Lifecycle lifecycle, ServiceEmitter serviceEmitter, NamespaceExtractionConfig config) {
        super(lifecycle, serviceEmitter, config);
        try {
            this.tmpFile = File.createTempFile("druidMapDB", this.getClass().getName());
            log.info("Using file [%s] for mapDB off heap namespace cache", new Object[]{this.tmpFile.getAbsolutePath()});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mmapDB = DBMaker.newFileDB((File)this.tmpFile).closeOnJvmShutdown().transactionDisable().deleteFilesAfterClose().strictDBGet().asyncWriteEnable().mmapFileEnable().commitFileSyncDisable().cacheSize(config.getNumBufferedEntries()).make();
        try {
            lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                public void start() {
                }

                public synchronized void stop() {
                    if (!OffHeapNamespaceExtractionCacheManager.this.mmapDB.isClosed()) {
                        OffHeapNamespaceExtractionCacheManager.this.mmapDB.close();
                        if (!OffHeapNamespaceExtractionCacheManager.this.tmpFile.delete()) {
                            log.warn("Unable to delete file at [%s]", new Object[]{OffHeapNamespaceExtractionCacheManager.this.tmpFile.getAbsolutePath()});
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CacheHandler createCache() {
        CacheProxy cache;
        String mapDbKey;
        while (true) {
            mapDbKey = Long.toString(this.mapDbKeyCounter.getAndIncrement());
            try {
                HTreeMap hTreeMap = this.mmapDB.createHashMap(mapDbKey).make();
                cache = new CacheProxy((ConcurrentMap<String, String>)hTreeMap);
                this.cacheCount.incrementAndGet();
            }
            catch (IllegalArgumentException hTreeMap) {
                continue;
            }
            break;
        }
        MapDbCacheDisposer cacheDisposer = new MapDbCacheDisposer(mapDbKey);
        Cleaners.Cleanable cleanable = Cleaners.register((Object)((Object)cache), (Runnable)cacheDisposer);
        MapDbCacheDisposerAndCleaner disposerAndCleaner = new MapDbCacheDisposerAndCleaner(cacheDisposer, cleanable);
        return new CacheHandler(this, (Map<String, String>)((Object)cache), disposerAndCleaner);
    }

    @Override
    public CacheHandler allocateCache() {
        return this.createCache();
    }

    @Override
    public CacheHandler attachCache(CacheHandler cache) {
        return cache;
    }

    @Override
    void disposeCache(CacheHandler cacheHandler) {
        MapDbCacheDisposerAndCleaner disposerAndCleaner = (MapDbCacheDisposerAndCleaner)cacheHandler.id;
        disposerAndCleaner.cacheDisposer.disposeManually();
        disposerAndCleaner.cleanable.clean();
    }

    @Override
    int cacheCount() {
        return this.cacheCount.get();
    }

    @Override
    void monitor(ServiceEmitter serviceEmitter) {
        serviceEmitter.emit(ServiceMetricEvent.builder().build("namespace/cache/count", (Number)this.cacheCount()));
        serviceEmitter.emit(ServiceMetricEvent.builder().build("namespace/cache/diskSize", (Number)this.tmpFile.length()));
    }

    private static final class CacheProxy
    extends ForwardingConcurrentMap<String, String> {
        private final ConcurrentMap<String, String> delegate;

        CacheProxy(ConcurrentMap<String, String> delegate) {
            this.delegate = delegate;
        }

        protected ConcurrentMap<String, String> delegate() {
            return this.delegate;
        }
    }

    private static class MapDbCacheDisposerAndCleaner {
        final MapDbCacheDisposer cacheDisposer;
        final Cleaners.Cleanable cleanable;

        private MapDbCacheDisposerAndCleaner(MapDbCacheDisposer cacheDisposer, Cleaners.Cleanable cleanable) {
            this.cacheDisposer = cacheDisposer;
            this.cleanable = cleanable;
        }
    }

    private class MapDbCacheDisposer
    implements Runnable {
        final String mapDbKey;
        final AtomicBoolean disposed = new AtomicBoolean(false);

        private MapDbCacheDisposer(String mapDbKey) {
            this.mapDbKey = mapDbKey;
        }

        @Override
        public void run() {
            if (this.disposed.compareAndSet(false, true)) {
                try {
                    this.doDispose();
                    log.error("OffHeapNamespaceExtractionCacheManager.disposeCache() was not called, disposed resources by the JVM", new Object[0]);
                }
                catch (Throwable t) {
                    try {
                        log.error(t, "Error while deleting key %s from MapDb", new Object[]{this.mapDbKey});
                    }
                    catch (Exception e) {
                        t.addSuppressed(e);
                    }
                    Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                }
            }
        }

        void disposeManually() {
            if (this.disposed.compareAndSet(false, true)) {
                this.doDispose();
            }
        }

        private void doDispose() {
            if (!OffHeapNamespaceExtractionCacheManager.this.mmapDB.isClosed()) {
                OffHeapNamespaceExtractionCacheManager.this.mmapDB.delete(this.mapDbKey);
            }
            OffHeapNamespaceExtractionCacheManager.this.cacheCount.decrementAndGet();
        }
    }
}

