/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.namespace.cache;

import com.google.inject.Inject;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.server.lookup.namespace.NamespaceExtractionConfig;
import org.apache.druid.server.lookup.namespace.cache.CacheHandler;
import org.apache.druid.server.lookup.namespace.cache.NamespaceExtractionCacheManager;

public class OnHeapNamespaceExtractionCacheManager
extends NamespaceExtractionCacheManager {
    private static final Logger LOG = new Logger(OnHeapNamespaceExtractionCacheManager.class);
    private final Set<WeakReference<Map<String, String>>> caches = Collections.newSetFromMap(new ConcurrentHashMap());

    @Inject
    public OnHeapNamespaceExtractionCacheManager(Lifecycle lifecycle, ServiceEmitter serviceEmitter, NamespaceExtractionConfig config) {
        super(lifecycle, serviceEmitter, config);
    }

    private void expungeCollectedCaches() {
        Iterator<WeakReference<Map<String, String>>> iterator = this.caches.iterator();
        while (iterator.hasNext()) {
            WeakReference<Map<String, String>> cacheRef = iterator.next();
            if (cacheRef.get() != null) continue;
            iterator.remove();
        }
    }

    @Override
    public CacheHandler createCache() {
        ConcurrentHashMap<String, String> cache = new ConcurrentHashMap<String, String>();
        WeakReference cacheRef = new WeakReference(cache);
        this.expungeCollectedCaches();
        this.caches.add(cacheRef);
        return new CacheHandler(this, cache, cacheRef);
    }

    @Override
    public CacheHandler allocateCache() {
        HashMap<String, String> cache = new HashMap<String, String>();
        return new CacheHandler(this, cache, new WeakReference(cache));
    }

    @Override
    public CacheHandler attachCache(CacheHandler cache) {
        if (this.caches.contains((WeakReference)cache.id)) {
            throw new ISE("cache [%s] is already attached", new Object[]{cache.id});
        }
        Map<String, String> immutable = Collections.unmodifiableMap(cache.getCache());
        WeakReference<Map<String, String>> cacheRef = new WeakReference<Map<String, String>>(immutable);
        this.expungeCollectedCaches();
        this.caches.add(cacheRef);
        return new CacheHandler(this, immutable, cacheRef);
    }

    @Override
    void disposeCache(CacheHandler cacheHandler) {
        if (!(cacheHandler.id instanceof WeakReference)) {
            throw new ISE("Expected WeakReference, got: %s", new Object[]{cacheHandler.id});
        }
        this.caches.remove(cacheHandler.id);
    }

    @Override
    int cacheCount() {
        this.expungeCollectedCaches();
        return this.caches.size();
    }

    @Override
    void monitor(ServiceEmitter serviceEmitter) {
        long numEntries = 0L;
        long heapSizeInBytes = 0L;
        this.expungeCollectedCaches();
        for (WeakReference<Map<String, String>> cacheRef : this.caches) {
            Map cache = (Map)cacheRef.get();
            if (cache == null) continue;
            numEntries += (long)cache.size();
            heapSizeInBytes += MapLookupExtractor.estimateHeapFootprint((Map)cache);
        }
        serviceEmitter.emit(ServiceMetricEvent.builder().build("namespace/cache/numEntries", (Number)numEntries));
        serviceEmitter.emit(ServiceMetricEvent.builder().build("namespace/cache/heapSizeInBytes", (Number)heapSizeInBytes));
    }
}

