/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.jdbc;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.server.initialization.JdbcAccessSecurityConfig;
import org.apache.druid.server.lookup.DataFetcher;
import org.apache.druid.server.lookup.jdbc.KeyValueResultSetMapper;
import org.apache.druid.server.lookup.jdbc.QueryKeys;
import org.apache.druid.utils.ConnectionUriUtils;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class JdbcDataFetcher
implements DataFetcher<String, String> {
    private static final Logger LOGGER;
    private static final int DEFAULT_STREAMING_FETCH_SIZE = 1000;
    @JsonProperty
    private final MetadataStorageConnectorConfig connectorConfig;
    @JsonProperty
    private final String table;
    @JsonProperty
    private final String keyColumn;
    @JsonProperty
    private final String valueColumn;
    @JsonProperty
    private final int streamingFetchSize;
    private final String fetchAllQuery;
    private final String fetchQuery;
    private final String reverseFetchQuery;
    private final DBI dbi;

    JdbcDataFetcher(@JsonProperty(value="connectorConfig") MetadataStorageConnectorConfig connectorConfig, @JsonProperty(value="table") String table, @JsonProperty(value="keyColumn") String keyColumn, @JsonProperty(value="valueColumn") String valueColumn, @JsonProperty(value="streamingFetchSize") @Nullable Integer streamingFetchSize, @JacksonInject JdbcAccessSecurityConfig securityConfig) {
        this.connectorConfig = (MetadataStorageConnectorConfig)Preconditions.checkNotNull((Object)connectorConfig, (Object)"connectorConfig");
        this.streamingFetchSize = streamingFetchSize == null ? 1000 : streamingFetchSize;
        JdbcDataFetcher.checkConnectionURL(connectorConfig.getConnectURI(), securityConfig);
        this.table = (String)Preconditions.checkNotNull((Object)table, (Object)"table");
        this.keyColumn = (String)Preconditions.checkNotNull((Object)keyColumn, (Object)"keyColumn");
        this.valueColumn = (String)Preconditions.checkNotNull((Object)valueColumn, (Object)"valueColumn");
        this.fetchAllQuery = StringUtils.format((String)"SELECT %s, %s FROM %s", (Object[])new Object[]{this.keyColumn, this.valueColumn, this.table});
        this.fetchQuery = StringUtils.format((String)"SELECT %s FROM %s WHERE %s = :val", (Object[])new Object[]{this.valueColumn, this.table, this.keyColumn});
        this.reverseFetchQuery = StringUtils.format((String)"SELECT %s FROM %s WHERE %s = :val", (Object[])new Object[]{this.keyColumn, this.table, this.valueColumn});
        this.dbi = new DBI(connectorConfig.getConnectURI(), connectorConfig.getUser(), connectorConfig.getPassword());
        this.dbi.registerMapper((ResultSetMapper)new KeyValueResultSetMapper(keyColumn, valueColumn));
    }

    private static void checkConnectionURL(String url, JdbcAccessSecurityConfig securityConfig) {
        Preconditions.checkNotNull((Object)url, (Object)"connectorConfig.connectURI");
        if (!securityConfig.isEnforceAllowedProperties()) {
            return;
        }
        ConnectionUriUtils.throwIfPropertiesAreNotAllowed((Set)ConnectionUriUtils.tryParseJdbcUriParameters((String)url, (boolean)securityConfig.isAllowUnknownJdbcUrlFormat()), (Set)securityConfig.getSystemPropertyPrefixes(), (Set)securityConfig.getAllowedProperties());
    }

    @Override
    public Iterable<Map.Entry<String, String>> fetchAll() {
        return (Iterable)this.inReadOnlyTransaction((handle, status) -> handle.createQuery(this.fetchAllQuery).setFetchSize(this.streamingFetchSize).map((ResultSetMapper)new KeyValueResultSetMapper(this.keyColumn, this.valueColumn)).list());
    }

    @Override
    public String fetch(String key) {
        List pairs = (List)this.inReadOnlyTransaction((handle, status) -> ((Query)handle.createQuery(this.fetchQuery).bind("val", key)).map((ResultSetMapper)StringMapper.FIRST).list());
        if (pairs.isEmpty()) {
            return null;
        }
        return NullHandling.nullToEmptyIfNeeded((String)((String)pairs.get(0)));
    }

    @Override
    public Iterable<Map.Entry<String, String>> fetch(Iterable<String> keys) {
        return (Iterable)this.runWithMissingJdbcJarHandler(() -> {
            QueryKeys queryKeys = (QueryKeys)this.dbi.onDemand(QueryKeys.class);
            return queryKeys.findNamesForIds(Lists.newArrayList((Iterable)keys), this.table, this.keyColumn, this.valueColumn);
        });
    }

    @Override
    public List<String> reverseFetchKeys(String value) {
        return (List)this.inReadOnlyTransaction((handle, status) -> ((Query)handle.createQuery(this.reverseFetchQuery).bind("val", value)).map((ResultSetMapper)StringMapper.FIRST).list());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcDataFetcher)) {
            return false;
        }
        JdbcDataFetcher that = (JdbcDataFetcher)o;
        if (!this.connectorConfig.equals((Object)that.connectorConfig)) {
            return false;
        }
        if (!this.table.equals(that.table)) {
            return false;
        }
        if (!this.keyColumn.equals(that.keyColumn)) {
            return false;
        }
        return this.valueColumn.equals(that.valueColumn);
    }

    public int hashCode() {
        return Objects.hash(this.connectorConfig, this.table, this.keyColumn, this.valueColumn);
    }

    public String toString() {
        return "JdbcDataFetcher{table='" + this.table + '\'' + ", keyColumn='" + this.keyColumn + '\'' + ", valueColumn='" + this.valueColumn + '\'' + '}';
    }

    private DBI getDbi() {
        return this.dbi;
    }

    private <T> T inReadOnlyTransaction(TransactionCallback<T> callback) {
        return (T)this.runWithMissingJdbcJarHandler(() -> this.getDbi().withHandle(handle -> {
            Connection connection = handle.getConnection();
            boolean readOnly = connection.isReadOnly();
            connection.setReadOnly(true);
            try {
                Object object = handle.inTransaction(callback);
                return object;
            }
            finally {
                try {
                    connection.setReadOnly(readOnly);
                }
                catch (SQLException e) {
                    LOGGER.error((Throwable)e, "Unable to reset connection read-only state", new Object[0]);
                }
            }
        }));
    }

    private <T> T runWithMissingJdbcJarHandler(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (UnableToObtainConnectionException e) {
            if (e.getMessage().contains("No suitable driver found")) {
                throw new ISE((Throwable)e, "JDBC driver JAR files missing in the classpath", new Object[0]);
            }
            throw e;
        }
    }

    static {
        NullHandling.initializeForTests();
        LOGGER = new Logger(JdbcDataFetcher.class);
    }
}

