/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.server.lookup.DataFetcher;
import org.apache.druid.server.lookup.LookupExtractionModule;
import org.apache.druid.server.lookup.cache.polling.OnHeapPollingCache;
import org.apache.druid.server.lookup.cache.polling.PollingCache;
import org.apache.druid.server.lookup.cache.polling.PollingCacheFactory;

public class PollingLookup
extends LookupExtractor {
    private static final Logger LOGGER = new Logger(PollingLookup.class);
    private final long pollPeriodMs;
    private final DataFetcher dataFetcher;
    private final PollingCacheFactory cacheFactory;
    private final AtomicReference<CacheRefKeeper> refOfCacheKeeper = new AtomicReference();
    private final ListeningScheduledExecutorService scheduledExecutorService;
    private final AtomicBoolean isOpen = new AtomicBoolean(false);
    private final ListenableFuture<?> pollFuture;
    private final String id = Integer.toHexString(System.identityHashCode((Object)this));

    public PollingLookup(long pollPeriodMs, DataFetcher dataFetcher, PollingCacheFactory cacheFactory) {
        this.pollPeriodMs = pollPeriodMs;
        this.dataFetcher = (DataFetcher)Preconditions.checkNotNull((Object)dataFetcher);
        this.cacheFactory = cacheFactory == null ? new OnHeapPollingCache.OnHeapPollingCacheProvider() : cacheFactory;
        this.refOfCacheKeeper.set(new CacheRefKeeper(this.cacheFactory.makeOf(dataFetcher.fetchAll())));
        if (pollPeriodMs > 0L) {
            this.scheduledExecutorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor(Execs.makeThreadFactory((String)("PollingLookup-" + StringUtils.encodeForFormat((String)this.id)), (Integer)1)));
            this.pollFuture = this.scheduledExecutorService.scheduleWithFixedDelay(this.pollAndSwap(), pollPeriodMs, pollPeriodMs, TimeUnit.MILLISECONDS);
        } else {
            this.scheduledExecutorService = null;
            this.pollFuture = null;
        }
        this.isOpen.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOGGER.info("Closing polling lookup [%s]", new Object[]{this.id});
        AtomicBoolean atomicBoolean = this.isOpen;
        synchronized (atomicBoolean) {
            CacheRefKeeper cacheRefKeeper;
            this.isOpen.getAndSet(false);
            if (this.pollFuture != null) {
                this.pollFuture.cancel(true);
                this.scheduledExecutorService.shutdown();
            }
            if ((cacheRefKeeper = (CacheRefKeeper)this.refOfCacheKeeper.getAndSet(null)) != null) {
                cacheRefKeeper.doneWithIt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String apply(@Nullable String key) {
        if (key == null) {
            return null;
        }
        CacheRefKeeper cacheRefKeeper = this.refOfCacheKeeper.get();
        if (cacheRefKeeper == null) {
            throw new ISE("Cache reference is null", new Object[0]);
        }
        PollingCache cache = cacheRefKeeper.getAndIncrementRef();
        try {
            if (cache == null) {
                String string = this.apply(key);
                return string;
            }
            String string = (String)cache.get(key);
            return string;
        }
        finally {
            if (cache != null) {
                cacheRefKeeper.doneWithIt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> unapply(@Nullable String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        CacheRefKeeper cacheRefKeeper = this.refOfCacheKeeper.get();
        if (cacheRefKeeper == null) {
            throw new ISE("pollingLookup id [%s] is closed", new Object[]{this.id});
        }
        PollingCache cache = cacheRefKeeper.getAndIncrementRef();
        try {
            if (cache == null) {
                List<String> list = this.unapply(value);
                return list;
            }
            List<String> list = cache.getKeys(value);
            return list;
        }
        finally {
            if (cache != null) {
                cacheRefKeeper.doneWithIt();
            }
        }
    }

    public boolean supportsAsMap() {
        return false;
    }

    public Map<String, String> asMap() {
        throw new UnsupportedOperationException("Cannot get map view");
    }

    public byte[] getCacheKey() {
        return LookupExtractionModule.getRandomCacheKey();
    }

    private Runnable pollAndSwap() {
        return new Runnable(){

            @Override
            public void run() {
                LOGGER.debug("Polling and swapping of PollingLookup [%s]", new Object[]{PollingLookup.this.id});
                CacheRefKeeper newCacheKeeper = new CacheRefKeeper(PollingLookup.this.cacheFactory.makeOf(PollingLookup.this.dataFetcher.fetchAll()));
                CacheRefKeeper oldCacheKeeper = PollingLookup.this.refOfCacheKeeper.getAndSet(newCacheKeeper);
                if (oldCacheKeeper != null) {
                    oldCacheKeeper.doneWithIt();
                }
            }
        };
    }

    public long estimateHeapFootprint() {
        PollingCache cache = null;
        while (cache == null) {
            CacheRefKeeper cacheRefKeeper = this.refOfCacheKeeper.get();
            if (cacheRefKeeper == null) {
                return 0L;
            }
            cache = cacheRefKeeper.getAndIncrementRef();
        }
        return cache.estimateHeapFootprint();
    }

    public int hashCode() {
        int result = (int)(this.pollPeriodMs ^ this.pollPeriodMs >>> 32);
        result = 31 * result + this.dataFetcher.hashCode();
        result = 31 * result + this.cacheFactory.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PollingLookup)) {
            return false;
        }
        PollingLookup that = (PollingLookup)((Object)o);
        if (this.pollPeriodMs != that.pollPeriodMs) {
            return false;
        }
        if (!this.dataFetcher.equals(that.dataFetcher)) {
            return false;
        }
        return this.cacheFactory.equals(that.cacheFactory);
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    public String toString() {
        return "PollingLookup{dataFetcher=" + this.dataFetcher + ", id='" + this.id + "'}";
    }

    protected static class CacheRefKeeper {
        private final PollingCache pollingCache;
        private final AtomicLong refCounts = new AtomicLong(0L);

        CacheRefKeeper(PollingCache pollingCache) {
            this.pollingCache = pollingCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PollingCache getAndIncrementRef() {
            AtomicLong atomicLong = this.refCounts;
            synchronized (atomicLong) {
                if (this.refCounts.get() < 0L) {
                    return null;
                }
                this.refCounts.incrementAndGet();
                return this.pollingCache;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doneWithIt() {
            AtomicLong atomicLong = this.refCounts;
            synchronized (atomicLong) {
                if (this.refCounts.get() == 0L) {
                    this.pollingCache.close();
                }
                this.refCounts.decrementAndGet();
            }
        }
    }
}

