/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.parquet.avro;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.avro.AvroFlattenerMaker;
import org.apache.druid.data.input.avro.AvroParseSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.joda.time.DateTime;

public class ParquetAvroHadoopInputRowParser
implements InputRowParser<GenericRecord> {
    private final ParseSpec parseSpec;
    private final boolean binaryAsString;
    private final boolean extractUnionsByType;
    private final TimestampSpec timestampSpec;
    private final ObjectFlattener<GenericRecord> recordFlattener;
    private final List<String> dimensions;

    @JsonCreator
    public ParquetAvroHadoopInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="binaryAsString") Boolean binaryAsString, @JsonProperty(value="extractUnionsByType") Boolean extractUnionsByType) {
        this.parseSpec = parseSpec;
        this.timestampSpec = parseSpec.getTimestampSpec();
        this.dimensions = parseSpec.getDimensionsSpec().getDimensionNames();
        this.binaryAsString = binaryAsString != null && binaryAsString != false;
        this.extractUnionsByType = extractUnionsByType != null && extractUnionsByType != false;
        JSONPathSpec flattenSpec = parseSpec instanceof AvroParseSpec ? (JSONPathSpec)((AvroParseSpec)parseSpec).getFlattenSpec() : JSONPathSpec.DEFAULT;
        this.recordFlattener = ObjectFlatteners.create((JSONPathSpec)flattenSpec, (ObjectFlatteners.FlattenerMaker)new AvroFlattenerMaker(false, this.binaryAsString, this.extractUnionsByType));
    }

    @Nullable
    private LogicalType determineTimestampSpecLogicalType(Schema schema, String timestampSpecField) {
        for (Schema.Field field : schema.getFields()) {
            if (!field.name().equals(timestampSpecField)) continue;
            return field.schema().getLogicalType();
        }
        return null;
    }

    @Nonnull
    public List<InputRow> parseBatch(GenericRecord record) {
        DateTime dateTime;
        Map row = this.recordFlattener.flatten((Object)record);
        ArrayList dimensions = !this.dimensions.isEmpty() ? this.dimensions : Lists.newArrayList((Iterable)Sets.difference(row.keySet(), (Set)this.parseSpec.getDimensionsSpec().getDimensionExclusions()));
        LogicalType logicalType = this.determineTimestampSpecLogicalType(record.getSchema(), this.timestampSpec.getTimestampColumn());
        if (logicalType instanceof LogicalTypes.Date) {
            int daysSinceEpoch = (Integer)record.get(this.timestampSpec.getTimestampColumn());
            dateTime = DateTimes.utc((long)TimeUnit.DAYS.toMillis(daysSinceEpoch));
        } else {
            dateTime = this.timestampSpec.extractTimestamp(row);
        }
        return ImmutableList.of((Object)new MapBasedInputRow(dateTime, (List)dimensions, row));
    }

    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new ParquetAvroHadoopInputRowParser(parseSpec, this.binaryAsString, this.extractUnionsByType);
    }
}

