/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.parquet.simple;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.parquet.simple.ParquetGroupConverter;
import org.apache.druid.data.input.parquet.simple.ParquetGroupJsonProvider;
import org.apache.druid.java.util.common.parsers.NotImplementedMappingProvider;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.schema.Type;

public class ParquetGroupFlattenerMaker
implements ObjectFlatteners.FlattenerMaker<Group> {
    private final Configuration jsonPathConfiguration;
    private final ParquetGroupConverter converter;
    private final JsonProvider parquetJsonProvider;

    public ParquetGroupFlattenerMaker(boolean binaryAsString) {
        this.converter = new ParquetGroupConverter(binaryAsString);
        this.parquetJsonProvider = new ParquetGroupJsonProvider(this.converter);
        this.jsonPathConfiguration = Configuration.builder().jsonProvider(this.parquetJsonProvider).mappingProvider((MappingProvider)new NotImplementedMappingProvider()).options(EnumSet.of(Option.SUPPRESS_EXCEPTIONS)).build();
    }

    public Set<String> discoverRootFields(Group obj) {
        return obj.getType().getFields().stream().filter(Type::isPrimitive).map(Type::getName).collect(Collectors.toSet());
    }

    public Object getRootField(Group obj, String key) {
        Object val = this.converter.convertField(obj, key);
        return this.finalizeConversion(val);
    }

    public Function<Group, Object> makeJsonPathExtractor(String expr) {
        JsonPath jsonPath = JsonPath.compile((String)expr, (Predicate[])new Predicate[0]);
        return record -> {
            Object val = jsonPath.read(record, this.jsonPathConfiguration);
            return this.finalizeConversion(val);
        };
    }

    @Nullable
    public Function<Group, Object> makeJsonQueryExtractor(String expr) {
        throw new UnsupportedOperationException("Parquet does not support JQ");
    }

    public JsonProvider getJsonProvider() {
        return this.parquetJsonProvider;
    }

    public Object finalizeConversionForMap(Object o) {
        return this.finalizeConversion(o);
    }

    private Object finalizeConversion(Object o) {
        List asList;
        if (ParquetGroupConverter.isWrappedListPrimitive(o)) {
            return this.converter.unwrapListPrimitive(o);
        }
        if (o instanceof List && (asList = ((List)o).stream().filter(Objects::nonNull).collect(Collectors.toList())).stream().allMatch(ParquetGroupConverter::isWrappedListPrimitive)) {
            return asList.stream().map(Group.class::cast).map(this.converter::unwrapListPrimitive).collect(Collectors.toList());
        }
        return o;
    }
}

