/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.parquet.simple;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.parquet.simple.ParquetParseSpec;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class DruidParquetReadSupport
extends GroupReadSupport {
    private MessageType getPartialReadSchema(InitContext context) {
        MessageType fullSchema = context.getFileSchema();
        String name = fullSchema.getName();
        HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromConfiguration((Configuration)context.getConfiguration());
        ParseSpec parseSpec = config.getParser().getParseSpec();
        if (parseSpec instanceof ParquetParseSpec && ((ParquetParseSpec)parseSpec).getFlattenSpec() != null) {
            return fullSchema;
        }
        String tsField = parseSpec.getTimestampSpec().getTimestampColumn();
        List dimensionSchema = parseSpec.getDimensionsSpec().getDimensions();
        HashSet<String> dimensions = new HashSet<String>();
        for (AggregatorFactory[] dim : dimensionSchema) {
            dimensions.add(dim.getName());
        }
        HashSet metricsFields = new HashSet();
        for (AggregatorFactory agg : config.getSchema().getDataSchema().getAggregators()) {
            metricsFields.addAll(agg.requiredFields());
        }
        ArrayList<Type> partialFields = new ArrayList<Type>();
        for (Type type : fullSchema.getFields()) {
            if (!tsField.equals(type.getName()) && !metricsFields.contains(type.getName()) && (dimensions.size() <= 0 || !dimensions.contains(type.getName())) && dimensions.size() != 0) continue;
            partialFields.add(type);
        }
        return new MessageType(name, partialFields);
    }

    public ReadSupport.ReadContext init(InitContext context) {
        MessageType requestedProjection = DruidParquetReadSupport.getSchemaForRead((MessageType)context.getFileSchema(), (MessageType)this.getPartialReadSchema(context));
        return new ReadSupport.ReadContext(requestedProjection);
    }
}

