/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.parquet.simple;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.data.input.parquet.simple.ParquetGroupConverter;
import org.apache.parquet.example.data.Group;

public class ParquetGroupJsonProvider
implements JsonProvider {
    private final ParquetGroupConverter converter;

    public ParquetGroupJsonProvider(ParquetGroupConverter converter) {
        this.converter = converter;
    }

    public Object createArray() {
        return new ArrayList();
    }

    public Object createMap() {
        return new HashMap();
    }

    public boolean isArray(Object o) {
        return o instanceof List;
    }

    public boolean isMap(Object o) {
        return o == null || o instanceof Map || o instanceof Group;
    }

    public int length(Object o) {
        if (o instanceof List) {
            return ((List)o).size();
        }
        if (o instanceof Group) {
            Group g = (Group)o;
            return g.getType().getFields().size();
        }
        return 0;
    }

    public Iterable<?> toIterable(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        throw new UnsupportedOperationException(o.getClass().getName());
    }

    public Collection<String> getPropertyKeys(Object o) {
        if (o == null) {
            return Collections.emptySet();
        }
        if (o instanceof Map) {
            return ((Map)o).keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        }
        if (o instanceof Group) {
            return ((Group)o).getType().getFields().stream().map(f -> f.getName()).collect(Collectors.toSet());
        }
        throw new UnsupportedOperationException(o.getClass().getName());
    }

    public Object getMapValue(Object o, String s) {
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            return ((Map)o).get(s);
        }
        if (o instanceof Group) {
            Group g = (Group)o;
            return this.converter.convertField(g, s);
        }
        throw new UnsupportedOperationException(o.getClass().getName());
    }

    public Object getArrayIndex(Object o, int i) {
        if (o instanceof List) {
            return ((List)o).get(i);
        }
        throw new UnsupportedOperationException(o.getClass().getName());
    }

    public void setArrayIndex(Object o, int i, Object o1) {
        if (o instanceof List) {
            List list = (List)o;
            if (list.size() == i) {
                list.add(o1);
            } else {
                list.set(i, o1);
            }
        } else {
            throw new UnsupportedOperationException(o.getClass().getName());
        }
    }

    public void setProperty(Object o, Object o1, Object o2) {
        if (!(o instanceof Map)) {
            throw new UnsupportedOperationException(o.getClass().getName());
        }
        ((Map)o).put(o1, o2);
    }

    public void removeProperty(Object o, Object o1) {
        if (!(o instanceof Map)) {
            throw new UnsupportedOperationException(o.getClass().getName());
        }
        ((Map)o).remove(o1);
    }

    @Deprecated
    public Object getArrayIndex(Object o, int i, boolean b) {
        throw new UnsupportedOperationException("Deprecated");
    }

    public Object parse(String s) throws InvalidJsonException {
        throw new UnsupportedOperationException("Unused");
    }

    public Object parse(InputStream inputStream, String s) throws InvalidJsonException {
        throw new UnsupportedOperationException("Unused");
    }

    public String toJson(Object o) {
        throw new UnsupportedOperationException("Unused");
    }

    public Object unwrap(Object o) {
        return o;
    }
}

