/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import org.apache.kafka.common.config.ConfigDef;

public class SchemaRegistryClientConfig {
    public static final String CLIENT_NAMESPACE = "schema.registry.";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE = "basic.auth.credentials.source";
    @Deprecated
    public static final String SCHEMA_REGISTRY_USER_INFO_CONFIG = "schema.registry.basic.auth.user.info";
    public static final String USER_INFO_CONFIG = "basic.auth.user.info";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE = "bearer.auth.credentials.source";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "bearer.auth.token";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";

    public static void withClientSslSupport(ConfigDef configDef, String namespace) {
        ConfigDef sslConfigDef = new ConfigDef();
        sslConfigDef.withClientSslSupport();
        for (ConfigDef.ConfigKey configKey : sslConfigDef.configKeys().values()) {
            configDef.define(namespace + configKey.name, SchemaRegistryClientConfig.typeFor(configKey.type), configKey.defaultValue, SchemaRegistryClientConfig.importanceFor(configKey.importance), configKey.documentation);
        }
    }

    private static ConfigDef.Type typeFor(ConfigDef.Type type) {
        return ConfigDef.Type.valueOf(type.name());
    }

    private static ConfigDef.Importance importanceFor(ConfigDef.Importance importance) {
        return ConfigDef.Importance.valueOf(importance.name());
    }
}

