/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;

public class Schemas {
    public static String toString(Schema schema, Collection<Schema> schemas) {
        return Schemas.toString(schema, schemas, false);
    }

    public static String toString(Schema schema, Collection<Schema> schemas, boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator gen = Schema.FACTORY.createGenerator(writer);
            if (pretty) {
                gen.useDefaultPrettyPrinter();
            }
            Schema.Names names = new Schema.Names();
            if (schemas != null) {
                for (Schema s : schemas) {
                    names.add(s);
                }
            }
            schema.toJson(names, gen);
            gen.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }
}

