/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.os72.protobuf.dynamic.DynamicSchema;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.data.input.protobuf.ProtobufBytesDecoder;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;

public class FileBasedProtobufBytesDecoder
implements ProtobufBytesDecoder {
    private final String descriptorFilePath;
    private final String protoMessageType;
    private Descriptors.Descriptor descriptor;

    @JsonCreator
    public FileBasedProtobufBytesDecoder(@JsonProperty(value="descriptor") String descriptorFilePath, @JsonProperty(value="protoMessageType") String protoMessageType) {
        this.descriptorFilePath = descriptorFilePath;
        this.protoMessageType = protoMessageType;
        this.initDescriptor();
    }

    @JsonProperty
    public String getDescriptor() {
        return this.descriptorFilePath;
    }

    @JsonProperty
    public String getProtoMessageType() {
        return this.protoMessageType;
    }

    @VisibleForTesting
    void initDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.getDescriptor(this.descriptorFilePath);
        }
    }

    @Override
    public DynamicMessage parse(ByteBuffer bytes) {
        try {
            DynamicMessage message = DynamicMessage.parseFrom(this.descriptor, ByteString.copyFrom(bytes));
            return message;
        }
        catch (Exception e) {
            throw new ParseException(null, (Throwable)e, "Fail to decode protobuf message!", new Object[0]);
        }
    }

    private Descriptors.Descriptor getDescriptor(String descriptorFilePath) {
        DynamicSchema dynamicSchema;
        InputStream fin = this.getClass().getClassLoader().getResourceAsStream(descriptorFilePath);
        if (fin == null) {
            URL url;
            try {
                url = new URL(descriptorFilePath);
            }
            catch (MalformedURLException e) {
                throw new ParseException(descriptorFilePath, (Throwable)e, "Descriptor not found in class path or malformed URL:" + descriptorFilePath, new Object[0]);
            }
            try {
                fin = url.openConnection().getInputStream();
            }
            catch (IOException e) {
                throw new ParseException(url.toString(), (Throwable)e, "Cannot read descriptor file: " + url, new Object[0]);
            }
        }
        try {
            dynamicSchema = DynamicSchema.parseFrom(fin);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new ParseException(null, (Throwable)e, "Invalid descriptor file: " + descriptorFilePath, new Object[0]);
        }
        catch (IOException e) {
            throw new ParseException(null, (Throwable)e, "Cannot read descriptor file: " + descriptorFilePath, new Object[0]);
        }
        Set<String> messageTypes = dynamicSchema.getMessageTypes();
        if (messageTypes.size() == 0) {
            throw new ParseException(null, "No message types found in the descriptor: " + descriptorFilePath, new Object[0]);
        }
        String messageType = this.protoMessageType == null ? (String)messageTypes.toArray()[0] : this.protoMessageType;
        Descriptors.Descriptor desc = dynamicSchema.getMessageDescriptor(messageType);
        if (desc == null) {
            throw new ParseException(null, StringUtils.format((String)"Protobuf message type %s not found in the specified descriptor.  Available messages types are %s", (Object[])new Object[]{this.protoMessageType, messageTypes}), new Object[0]);
        }
        return desc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBasedProtobufBytesDecoder that = (FileBasedProtobufBytesDecoder)o;
        return Objects.equals(this.descriptorFilePath, that.descriptorFilePath) && Objects.equals(this.protoMessageType, that.protoMessageType);
    }

    public int hashCode() {
        return Objects.hash(this.descriptorFilePath, this.protoMessageType);
    }
}

