/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterators;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.protobuf.ProtobufBytesDecoder;
import org.apache.druid.data.input.protobuf.ProtobufInputRowSchema;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.JSONFlattenerMaker;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.utils.CollectionUtils;

public class ProtobufReader
extends IntermediateRowParsingReader<DynamicMessage> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final InputRowSchema inputRowSchema;
    private final InputEntity source;
    private final JSONPathSpec flattenSpec;
    private final ObjectFlattener<JsonNode> recordFlattener;
    private final ProtobufBytesDecoder protobufBytesDecoder;

    ProtobufReader(InputRowSchema inputRowSchema, InputEntity source, ProtobufBytesDecoder protobufBytesDecoder, JSONPathSpec flattenSpec) {
        if (flattenSpec == null) {
            this.inputRowSchema = new ProtobufInputRowSchema(inputRowSchema);
            this.recordFlattener = null;
        } else {
            this.inputRowSchema = inputRowSchema;
            this.recordFlattener = ObjectFlatteners.create((JSONPathSpec)flattenSpec, (ObjectFlatteners.FlattenerMaker)new JSONFlattenerMaker(true));
        }
        this.source = source;
        this.protobufBytesDecoder = protobufBytesDecoder;
        this.flattenSpec = flattenSpec;
    }

    protected CloseableIterator<DynamicMessage> intermediateRowIterator() throws IOException {
        return CloseableIterators.withEmptyBaggage((Iterator)Iterators.singletonIterator((Object)this.protobufBytesDecoder.parse(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)this.source.open())))));
    }

    protected InputEntity source() {
        return this.source;
    }

    protected List<InputRow> parseInputRows(DynamicMessage intermediateRow) throws ParseException, JsonProcessingException {
        Map record;
        if (this.flattenSpec == null || JSONPathSpec.DEFAULT.equals((Object)this.flattenSpec)) {
            try {
                record = CollectionUtils.mapKeys(intermediateRow.getAllFields(), k -> k.getJsonName());
            }
            catch (Exception ex) {
                throw new ParseException(null, (Throwable)ex, "Protobuf message could not be parsed", new Object[0]);
            }
        }
        try {
            String json = JsonFormat.printer().print(intermediateRow);
            record = this.recordFlattener.flatten(OBJECT_MAPPER.readValue(json, JsonNode.class));
        }
        catch (InvalidProtocolBufferException e) {
            throw new ParseException(null, (Throwable)e, "Protobuf message could not be parsed", new Object[0]);
        }
        return Collections.singletonList(MapInputRowParser.parse((InputRowSchema)this.inputRowSchema, (Map)record));
    }

    protected List<Map<String, Object>> toMap(DynamicMessage intermediateRow) throws JsonProcessingException, InvalidProtocolBufferException {
        return Collections.singletonList(new ObjectMapper().readValue(JsonFormat.printer().print(intermediateRow), Map.class));
    }
}

