/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.apache.druid.data.input.protobuf.ProtobufJsonProvider;
import org.apache.druid.java.util.common.parsers.JSONFlattenerMaker;
import org.apache.druid.java.util.common.parsers.NotImplementedMappingProvider;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;

public class ProtobufFlattenerMaker
implements ObjectFlatteners.FlattenerMaker<Map<String, Object>> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ProtobufJsonProvider JSON_PROVIDER = new ProtobufJsonProvider();
    private static final Configuration CONFIG = Configuration.builder().jsonProvider((JsonProvider)JSON_PROVIDER).mappingProvider((MappingProvider)new NotImplementedMappingProvider()).options(EnumSet.of(Option.SUPPRESS_EXCEPTIONS)).build();
    private final CharsetEncoder enc = StandardCharsets.UTF_8.newEncoder();

    public JsonProvider getJsonProvider() {
        return JSON_PROVIDER;
    }

    public Iterable<String> discoverRootFields(Map<String, Object> obj) {
        HashSet rootFields = Sets.newHashSetWithExpectedSize((int)obj.keySet().size());
        for (Map.Entry<String, Object> entry : obj.entrySet()) {
            if (entry.getValue() instanceof List || entry.getValue() instanceof Map) continue;
            rootFields.add(entry.getKey());
        }
        return rootFields;
    }

    public Object getRootField(Map<String, Object> obj, String key) {
        return obj.get(key);
    }

    public Function<Map<String, Object>, Object> makeJsonPathExtractor(String expr) {
        JsonPath path = JsonPath.compile((String)expr, (Predicate[])new Predicate[0]);
        return map -> path.read(map, CONFIG);
    }

    public Function<Map<String, Object>, Object> makeJsonQueryExtractor(String expr) {
        JsonQuery jsonQuery;
        try {
            jsonQuery = JsonQuery.compile((String)expr);
        }
        catch (JsonQueryException e) {
            throw new RuntimeException(e);
        }
        return map -> {
            try {
                return JSONFlattenerMaker.convertJsonNode((JsonNode)((JsonNode)jsonQuery.apply(OBJECT_MAPPER.valueToTree(map)).get(0)), (CharsetEncoder)this.enc);
            }
            catch (JsonQueryException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

