/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3.output;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.io.CountingOutputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;
import org.apache.druid.storage.s3.output.S3OutputConfig;

public class RetryableS3OutputStream
extends OutputStream {
    private static final Logger LOG = new Logger(RetryableS3OutputStream.class);
    private final S3OutputConfig config;
    private final ServerSideEncryptingAmazonS3 s3;
    private final String s3Key;
    private final String uploadId;
    private final File chunkStorePath;
    private final long chunkSize;
    private final List<PartETag> pushResults = new ArrayList<PartETag>();
    private final byte[] singularBuffer = new byte[1];
    private final Stopwatch pushStopwatch;
    private Chunk currentChunk;
    private int nextChunkId = 1;
    private int numChunksPushed;
    private long resultsSize;
    private boolean error;
    private boolean closed;

    public RetryableS3OutputStream(S3OutputConfig config, ServerSideEncryptingAmazonS3 s3, String s3Key) throws IOException {
        this(config, s3, s3Key, true);
    }

    @VisibleForTesting
    protected RetryableS3OutputStream(S3OutputConfig config, ServerSideEncryptingAmazonS3 s3, String s3Key, boolean chunkValidation) throws IOException {
        this.config = config;
        this.s3 = s3;
        this.s3Key = s3Key;
        InitiateMultipartUploadResult result = s3.initiateMultipartUpload(new InitiateMultipartUploadRequest(config.getBucket(), s3Key));
        this.uploadId = result.getUploadId();
        this.chunkStorePath = new File(config.getTempDir(), this.uploadId + UUID.randomUUID());
        org.apache.druid.java.util.common.FileUtils.mkdirp((File)this.chunkStorePath);
        this.chunkSize = config.getChunkSize();
        this.pushStopwatch = Stopwatch.createUnstarted();
        this.pushStopwatch.reset();
        this.currentChunk = new Chunk(this.nextChunkId, new File(this.chunkStorePath, String.valueOf(this.nextChunkId++)));
    }

    @Override
    public void write(int b) throws IOException {
        this.singularBuffer[0] = (byte)b;
        this.write(this.singularBuffer, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            this.error = true;
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            this.error = true;
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        try {
            int writtenBytes;
            int offsetToWrite = off;
            for (int remainingBytesToWrite = len; remainingBytesToWrite > 0; remainingBytesToWrite -= writtenBytes) {
                writtenBytes = this.writeToCurrentChunk(b, offsetToWrite, remainingBytesToWrite);
                if (this.currentChunk.length() >= this.chunkSize) {
                    this.pushCurrentChunk();
                    this.currentChunk = new Chunk(this.nextChunkId, new File(this.chunkStorePath, String.valueOf(this.nextChunkId++)));
                }
                offsetToWrite += writtenBytes;
            }
        }
        catch (IOException | RuntimeException e) {
            this.error = true;
            throw e;
        }
    }

    private int writeToCurrentChunk(byte[] b, int off, int len) throws IOException {
        int lenToWrite = Math.min(len, Math.toIntExact(this.chunkSize - this.currentChunk.length()));
        this.currentChunk.outputStream.write(b, off, lenToWrite);
        return lenToWrite;
    }

    private void pushCurrentChunk() throws IOException {
        Chunk chunk;
        block5: {
            this.currentChunk.close();
            chunk = this.currentChunk;
            try {
                if (chunk.length() <= 0L) break block5;
                this.resultsSize += chunk.length();
                if (this.resultsSize > this.config.getMaxResultsSize()) {
                    throw new IOE("Exceeded max results size [%s]", new Object[]{this.config.getMaxResultsSize()});
                }
                this.pushStopwatch.start();
                this.pushResults.add(this.push(chunk));
                this.pushStopwatch.stop();
                ++this.numChunksPushed;
            }
            catch (Throwable throwable) {
                if (!chunk.delete()) {
                    LOG.warn("Failed to delete chunk [%s]", new Object[]{chunk.getAbsolutePath()});
                }
                throw throwable;
            }
        }
        if (!chunk.delete()) {
            LOG.warn("Failed to delete chunk [%s]", new Object[]{chunk.getAbsolutePath()});
        }
    }

    private PartETag push(Chunk chunk) throws IOException {
        try {
            return (PartETag)RetryUtils.retry(() -> this.uploadPartIfPossible(this.uploadId, this.config.getBucket(), this.s3Key, chunk), S3Utils.S3RETRY, (int)this.config.getMaxRetry());
        }
        catch (AmazonServiceException e) {
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PartETag uploadPartIfPossible(String uploadId, String bucket, String key, Chunk chunk) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(this.resultsSize);
        UploadPartRequest uploadPartRequest = new UploadPartRequest().withUploadId(uploadId).withBucketName(bucket).withKey(key).withFile(chunk.file).withPartNumber(chunk.id).withPartSize(chunk.length());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pushing chunk [%s] to bucket[%s] and key[%s].", new Object[]{chunk, bucket, key});
        }
        UploadPartResult uploadResult = this.s3.uploadPart(uploadPartRequest);
        return uploadResult.getPartETag();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Closer closer = Closer.create();
        closer.register(() -> LOG.info("Total push time: [%d] ms", new Object[]{this.pushStopwatch.elapsed(TimeUnit.MILLISECONDS)}));
        closer.register(() -> FileUtils.forceDelete((File)this.chunkStorePath));
        closer.register(() -> {
            try {
                if (this.resultsSize > 0L && this.isAllPushSucceeded()) {
                    RetryUtils.retry(() -> this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.config.getBucket(), this.s3Key, this.uploadId, this.pushResults)), S3Utils.S3RETRY, (int)this.config.getMaxRetry());
                } else {
                    RetryUtils.retry(() -> {
                        this.s3.cancelMultiPartUpload(new AbortMultipartUploadRequest(this.config.getBucket(), this.s3Key, this.uploadId));
                        return null;
                    }, S3Utils.S3RETRY, (int)this.config.getMaxRetry());
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        });
        try (Closer ignored = closer;){
            if (!this.error) {
                this.pushCurrentChunk();
            }
        }
    }

    private boolean isAllPushSucceeded() {
        return !this.error && !this.pushResults.isEmpty() && this.numChunksPushed == this.pushResults.size();
    }

    private static class Chunk
    implements Closeable {
        private final int id;
        private final File file;
        private final CountingOutputStream outputStream;
        private boolean closed;

        private Chunk(int id, File file) throws FileNotFoundException {
            this.id = id;
            this.file = file;
            this.outputStream = new CountingOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(file)));
        }

        private long length() {
            return this.outputStream.getCount();
        }

        private boolean delete() {
            return this.file.delete();
        }

        private String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Chunk chunk = (Chunk)o;
            return this.id == chunk.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.outputStream.close();
        }

        public String toString() {
            return "Chunk{id=" + this.id + ", file=" + this.file.getAbsolutePath() + ", size=" + this.length() + '}';
        }
    }
}

