/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.IAE;

public class S3OutputConfig {
    public static final long S3_MULTIPART_UPLOAD_MIN_PART_SIZE_BYTES = 0x500000L;
    public static final long S3_MULTIPART_UPLOAD_MAX_PART_SIZE_BYTES = 0x140000000L;
    private static final int S3_MULTIPART_UPLOAD_MAX_NUM_PARTS = 10000;
    public static final long S3_MULTIPART_UPLOAD_MIN_OBJECT_SIZE_BYTES = 0x500000L;
    public static final long S3_MULTIPART_UPLOAD_MAX_OBJECT_SIZE_BYTES = 0x50000000000L;
    @JsonProperty
    private String bucket;
    @JsonProperty
    private String prefix;
    @JsonProperty
    private File tempDir;
    @Nullable
    @JsonProperty
    private HumanReadableBytes chunkSize;
    @JsonProperty
    private HumanReadableBytes maxResultsSize = new HumanReadableBytes("100MiB");
    @JsonProperty
    private int maxRetry = 10;

    @JsonCreator
    public S3OutputConfig(@JsonProperty(value="bucket", required=true) String bucket, @JsonProperty(value="prefix", required=true) String prefix, @JsonProperty(value="tempDir", required=true) File tempDir, @JsonProperty(value="chunkSize") HumanReadableBytes chunkSize, @JsonProperty(value="maxResultsSize") HumanReadableBytes maxResultsSize, @JsonProperty(value="maxRetry") Integer maxRetry) {
        this(bucket, prefix, tempDir, chunkSize, maxResultsSize, maxRetry, true);
    }

    @VisibleForTesting
    protected S3OutputConfig(String bucket, String prefix, File tempDir, @Nullable HumanReadableBytes chunkSize, @Nullable HumanReadableBytes maxResultsSize, @Nullable Integer maxRetry, boolean validation) {
        this.bucket = bucket;
        this.prefix = prefix;
        this.tempDir = tempDir;
        if (chunkSize != null) {
            this.chunkSize = chunkSize;
        }
        if (maxResultsSize != null) {
            this.maxResultsSize = maxResultsSize;
        }
        if (maxRetry != null) {
            this.maxRetry = maxRetry;
        }
        if (validation) {
            this.validateFields();
        }
    }

    private void validateFields() {
        if (this.chunkSize != null && (this.chunkSize.getBytes() < 0x500000L || this.chunkSize.getBytes() > 0x140000000L)) {
            throw new IAE("chunkSize[%d] should be >= [%d] and <= [%d] bytes or null", new Object[]{this.chunkSize.getBytes(), 0x500000L, 0x140000000L});
        }
        if (this.maxResultsSize.getBytes() < 0x500000L || this.maxResultsSize.getBytes() > 0x50000000000L) {
            throw new IAE("maxResultsSize[%d] should be >= [%d] and <= [%d] bytes", new Object[]{this.maxResultsSize.getBytes(), 0x500000L, 0x50000000000L});
        }
        if (this.chunkSize != null) {
            S3OutputConfig.validateChunkSize(this.maxResultsSize.getBytes(), this.chunkSize.getBytes());
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public Long getChunkSize() {
        return this.chunkSize == null ? S3OutputConfig.computeMinChunkSize(this.getMaxResultsSize()) : this.chunkSize.getBytes();
    }

    public long getMaxResultsSize() {
        return this.maxResultsSize.getBytes();
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public static long computeMinChunkSize(long maxResultsSize) {
        return Math.max((long)Math.ceil((double)maxResultsSize / 10000.0), 0x500000L);
    }

    private static void validateChunkSize(long maxResultsSize, long chunkSize) {
        if (S3OutputConfig.computeMinChunkSize(maxResultsSize) > chunkSize) {
            throw new IAE("chunkSize[%d] is too small for maxResultsSize[%d]. chunkSize should be at least [%d]", new Object[]{chunkSize, maxResultsSize, S3OutputConfig.computeMinChunkSize(maxResultsSize)});
        }
        if (0x140000000L < chunkSize) {
            throw new IAE("chunkSize[%d] should be smaller than [%d]", new Object[]{chunkSize, 0x140000000L});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3OutputConfig that = (S3OutputConfig)o;
        return this.maxRetry == that.maxRetry && this.bucket.equals(that.bucket) && this.prefix.equals(that.prefix) && this.tempDir.equals(that.tempDir) && Objects.equals(this.chunkSize, that.chunkSize) && this.maxResultsSize.equals((Object)that.maxResultsSize);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.prefix, this.tempDir, this.chunkSize, this.maxResultsSize, this.maxRetry);
    }
}

