/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3.output;

import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.druid.data.input.impl.RetryingInputStream;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;
import org.apache.druid.storage.s3.output.RetryableS3OutputStream;
import org.apache.druid.storage.s3.output.S3OutputConfig;

public class S3StorageConnector
implements StorageConnector {
    private final S3OutputConfig config;
    private final ServerSideEncryptingAmazonS3 s3Client;
    private static final String DELIM = "/";
    private static final Joiner JOINER = Joiner.on((String)"/").skipNulls();

    public S3StorageConnector(S3OutputConfig config, ServerSideEncryptingAmazonS3 serverSideEncryptingAmazonS3) {
        this.config = config;
        this.s3Client = serverSideEncryptingAmazonS3;
    }

    public boolean pathExists(String path) {
        return this.s3Client.doesObjectExist(this.config.getBucket(), this.objectPath(path));
    }

    public InputStream read(String path) throws IOException {
        return new RetryingInputStream((Object)new GetObjectRequest(this.config.getBucket(), this.objectPath(path)), (ObjectOpenFunction)new ObjectOpenFunction<GetObjectRequest>(){

            public InputStream open(GetObjectRequest object) {
                return S3StorageConnector.this.s3Client.getObject(object).getObjectContent();
            }

            public InputStream open(GetObjectRequest object, long offset) {
                GetObjectRequest offsetObjectRequest = new GetObjectRequest(object.getBucketName(), object.getKey());
                offsetObjectRequest.setRange(offset);
                return this.open(offsetObjectRequest);
            }
        }, S3Utils.S3RETRY, Integer.valueOf(this.config.getMaxRetry()));
    }

    public OutputStream write(String path) throws IOException {
        return new RetryableS3OutputStream(this.config, this.s3Client, this.objectPath(path));
    }

    public void deleteFile(String path) {
        this.s3Client.deleteObject(this.config.getBucket(), this.objectPath(path));
    }

    public void deleteRecursively(String dirName) {
        ListObjectsV2Request listObjectsRequest = new ListObjectsV2Request().withBucketName(this.config.getBucket()).withPrefix(this.objectPath(dirName));
        ListObjectsV2Result objectListing = this.s3Client.listObjectsV2(listObjectsRequest);
        while (objectListing.getObjectSummaries().size() > 0) {
            List deleteObjectsRequestKeys = objectListing.getObjectSummaries().stream().map(S3ObjectSummary::getKey).map(DeleteObjectsRequest.KeyVersion::new).collect(Collectors.toList());
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.config.getBucket()).withKeys(deleteObjectsRequestKeys);
            this.s3Client.deleteObjects(deleteObjectsRequest);
            if (!objectListing.isTruncated()) break;
            listObjectsRequest.withContinuationToken(objectListing.getContinuationToken());
            objectListing = this.s3Client.listObjectsV2(listObjectsRequest);
        }
    }

    @Nonnull
    private String objectPath(String path) {
        return JOINER.join((Object)this.config.getPrefix(), (Object)path, new Object[0]);
    }
}

