/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.variance;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;

public class VarianceAggregatorCollector {
    public static final Comparator<VarianceAggregatorCollector> COMPARATOR = (o1, o2) -> {
        int compare = Doubles.compare((double)o1.nvariance, (double)o2.nvariance);
        if (compare == 0 && (compare = Longs.compare((long)o1.count, (long)o2.count)) == 0) {
            compare = Doubles.compare((double)o1.sum, (double)o2.sum);
        }
        return compare;
    };
    long count;
    double sum;
    double nvariance;

    public static boolean isVariancePop(@Nullable String estimator) {
        return estimator != null && "population".equalsIgnoreCase(estimator);
    }

    public static VarianceAggregatorCollector from(ByteBuffer buffer) {
        return new VarianceAggregatorCollector(buffer.getLong(), buffer.getDouble(), buffer.getDouble());
    }

    void fold(@Nullable VarianceAggregatorCollector other) {
        if (other == null || other.count == 0L) {
            return;
        }
        if (this.count == 0L) {
            this.nvariance = other.nvariance;
            this.count = other.count;
            this.sum = other.sum;
            return;
        }
        double ratio = (double)this.count / (double)other.count;
        double t = this.sum / ratio - other.sum;
        this.nvariance += other.nvariance + ratio / (double)(this.count + other.count) * t * t;
        this.count += other.count;
        this.sum += other.sum;
    }

    static Object combineValues(Object lhs, @Nullable Object rhs) {
        ((VarianceAggregatorCollector)lhs).fold((VarianceAggregatorCollector)rhs);
        return lhs;
    }

    static int getMaxIntermediateSize() {
        return 24;
    }

    public VarianceAggregatorCollector() {
        this(0L, 0.0, 0.0);
    }

    void copyFrom(VarianceAggregatorCollector other) {
        this.count = other.count;
        this.sum = other.sum;
        this.nvariance = other.nvariance;
    }

    public VarianceAggregatorCollector(long count, double sum, double nvariance) {
        this.count = count;
        this.sum = sum;
        this.nvariance = nvariance;
    }

    public VarianceAggregatorCollector add(float v) {
        ++this.count;
        this.sum += (double)v;
        if (this.count > 1L) {
            double t = (double)((float)this.count * v) - this.sum;
            this.nvariance += t * t / ((double)this.count * (double)(this.count - 1L));
        }
        return this;
    }

    public VarianceAggregatorCollector add(double v) {
        ++this.count;
        this.sum += v;
        if (this.count > 1L) {
            double t = (double)this.count * v - this.sum;
            this.nvariance += t * t / ((double)this.count * (double)(this.count - 1L));
        }
        return this;
    }

    public VarianceAggregatorCollector add(long v) {
        ++this.count;
        this.sum += (double)v;
        if (this.count > 1L) {
            double t = (double)(this.count * v) - this.sum;
            this.nvariance += t * t / ((double)this.count * (double)(this.count - 1L));
        }
        return this;
    }

    @Nullable
    public Double getVariance(boolean variancePop) {
        if (this.count == 0L) {
            return NullHandling.defaultDoubleValue();
        }
        if (this.count == 1L) {
            return 0.0;
        }
        return variancePop ? this.nvariance / (double)this.count : this.nvariance / (double)(this.count - 1L);
    }

    @JsonValue
    public byte[] toByteArray() {
        ByteBuffer buffer = this.toByteBuffer();
        buffer.flip();
        byte[] theBytes = new byte[buffer.remaining()];
        buffer.get(theBytes);
        return theBytes;
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.allocate(24).putLong(this.count).putDouble(this.sum).putDouble(this.nvariance);
    }

    @VisibleForTesting
    boolean equalsWithEpsilon(VarianceAggregatorCollector o, double epsilon) {
        if (this == o) {
            return true;
        }
        if (this.count != o.count) {
            return false;
        }
        if (Math.abs(this.sum - o.sum) > epsilon) {
            return false;
        }
        return !(Math.abs(this.nvariance - o.nvariance) > epsilon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarianceAggregatorCollector that = (VarianceAggregatorCollector)o;
        if (this.count != that.count) {
            return false;
        }
        if (Double.compare(that.sum, this.sum) != 0) {
            return false;
        }
        return Double.compare(that.nvariance, this.nvariance) == 0;
    }

    public int hashCode() {
        int result = (int)(this.count ^ this.count >>> 32);
        long temp = Double.doubleToLongBits(this.sum);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.nvariance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "VarianceHolder{count=" + this.count + ", sum=" + this.sum + ", nvariance=" + this.nvariance + '}';
    }
}

