/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.variance;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.variance.VarianceAggregatorCollector;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public abstract class VarianceBufferAggregator
implements BufferAggregator {
    private static final int COUNT_OFFSET = 0;
    private static final int SUM_OFFSET = 8;
    private static final int NVARIANCE_OFFSET = 16;

    public void init(ByteBuffer buf, int position) {
        VarianceBufferAggregator.doInit(buf, position);
    }

    public VarianceAggregatorCollector get(ByteBuffer buf, int position) {
        return VarianceBufferAggregator.getVarianceCollector(buf, position);
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("VarianceBufferAggregator does not support getFloat()");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("VarianceBufferAggregator does not support getFloat()");
    }

    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("VarianceBufferAggregator does not support getDouble()");
    }

    public void close() {
    }

    public static void doInit(ByteBuffer buf, int position) {
        buf.putLong(position + 0, 0L).putDouble(position + 8, 0.0).putDouble(position + 16, 0.0);
    }

    public static long getCount(ByteBuffer buf, int position) {
        return buf.getLong(position + 0);
    }

    public static double getSum(ByteBuffer buf, int position) {
        return buf.getDouble(position + 8);
    }

    public static double getVariance(ByteBuffer buf, int position) {
        return buf.getDouble(position + 16);
    }

    public static VarianceAggregatorCollector getVarianceCollector(ByteBuffer buf, int position) {
        return new VarianceAggregatorCollector(VarianceBufferAggregator.getCount(buf, position), VarianceBufferAggregator.getSum(buf, position), VarianceBufferAggregator.getVariance(buf, position));
    }

    public static void writeNVariance(ByteBuffer buf, int position, long count, double sum, double nvariance) {
        buf.putLong(position + 0, count);
        buf.putDouble(position + 8, sum);
        if (count > 1L) {
            buf.putDouble(position + 16, nvariance);
        }
    }

    public static void writeCountAndSum(ByteBuffer buf, int position, long count, double sum) {
        buf.putLong(position + 0, count);
        buf.putDouble(position + 8, sum);
    }

    public static final class ObjectVarianceAggregator
    extends VarianceBufferAggregator {
        private final BaseObjectColumnValueSelector selector;

        public ObjectVarianceAggregator(BaseObjectColumnValueSelector selector) {
            this.selector = selector;
        }

        public void aggregate(ByteBuffer buf, int position) {
            VarianceAggregatorCollector holder2 = (VarianceAggregatorCollector)this.selector.getObject();
            Preconditions.checkState((holder2 != null ? 1 : 0) != 0);
            if (holder2.count == 0L) {
                return;
            }
            long count = ObjectVarianceAggregator.getCount(buf, position);
            if (count == 0L) {
                buf.putLong(position, holder2.count);
                buf.putDouble(position + 8, holder2.sum);
                buf.putDouble(position + 16, holder2.nvariance);
                return;
            }
            double sum = ObjectVarianceAggregator.getSum(buf, position);
            double nvariance = buf.getDouble(position + 16);
            double ratio = (double)count / (double)holder2.count;
            double t = sum / ratio - holder2.sum;
            nvariance += holder2.nvariance + ratio / (double)(count + holder2.count) * t * t;
            ObjectVarianceAggregator.writeNVariance(buf, position, count += holder2.count, sum += holder2.sum, nvariance);
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("selector", (Object)this.selector);
        }
    }

    public static final class LongVarianceAggregator
    extends VarianceBufferAggregator {
        private final boolean noNulls = NullHandling.replaceWithDefault();
        private final BaseLongColumnValueSelector selector;

        public LongVarianceAggregator(BaseLongColumnValueSelector selector) {
            this.selector = selector;
        }

        public void aggregate(ByteBuffer buf, int position) {
            if (this.noNulls || !this.selector.isNull()) {
                long v = this.selector.getLong();
                long count = LongVarianceAggregator.getCount(buf, position) + 1L;
                double sum = LongVarianceAggregator.getSum(buf, position) + (double)v;
                LongVarianceAggregator.writeCountAndSum(buf, position, count, sum);
                if (count > 1L) {
                    double t = (double)(count * v) - sum;
                    double variance = buf.getDouble(position + 16) + t * t / ((double)count * (double)(count - 1L));
                    buf.putDouble(position + 16, variance);
                }
            }
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("selector", (HotLoopCallee)this.selector);
        }
    }

    public static final class DoubleVarianceAggregator
    extends VarianceBufferAggregator {
        private final boolean noNulls = NullHandling.replaceWithDefault();
        private final BaseDoubleColumnValueSelector selector;

        public DoubleVarianceAggregator(BaseDoubleColumnValueSelector selector) {
            this.selector = selector;
        }

        public void aggregate(ByteBuffer buf, int position) {
            if (this.noNulls || !this.selector.isNull()) {
                double v = this.selector.getDouble();
                long count = DoubleVarianceAggregator.getCount(buf, position) + 1L;
                double sum = DoubleVarianceAggregator.getSum(buf, position) + v;
                DoubleVarianceAggregator.writeCountAndSum(buf, position, count, sum);
                if (count > 1L) {
                    double t = (double)count * v - sum;
                    double variance = buf.getDouble(position + 16) + t * t / ((double)count * (double)(count - 1L));
                    buf.putDouble(position + 16, variance);
                }
            }
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("selector", (HotLoopCallee)this.selector);
        }
    }

    public static final class FloatVarianceAggregator
    extends VarianceBufferAggregator {
        private final boolean noNulls = NullHandling.replaceWithDefault();
        private final BaseFloatColumnValueSelector selector;

        public FloatVarianceAggregator(BaseFloatColumnValueSelector selector) {
            this.selector = selector;
        }

        public void aggregate(ByteBuffer buf, int position) {
            if (this.noNulls || !this.selector.isNull()) {
                float v = this.selector.getFloat();
                long count = FloatVarianceAggregator.getCount(buf, position) + 1L;
                double sum = FloatVarianceAggregator.getSum(buf, position) + (double)v;
                FloatVarianceAggregator.writeCountAndSum(buf, position, count, sum);
                if (count > 1L) {
                    double t = (double)((float)count * v) - sum;
                    double variance = buf.getDouble(position + 16) + t * t / ((double)count * (double)(count - 1L));
                    buf.putDouble(position + 16, variance);
                }
            }
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("selector", (HotLoopCallee)this.selector);
        }
    }
}

