/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expressions;

import java.util.List;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;

public class SleepExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String NAME = "sleep";

    public String name() {
        return NAME;
    }

    public Expr apply(final List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 1);
        Expr arg = args.get(0);
        class SleepExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            public SleepExpr(Expr arg) {
                super(SleepExprMacro.NAME, arg);
            }

            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval eval = this.arg.eval(bindings);
                try {
                    double seconds;
                    if (!eval.isNumericNull() && (seconds = eval.asDouble()) > 0.0) {
                        Thread.sleep((long)(seconds * 1000.0));
                    }
                    return ExprEval.of(null);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw SleepExprMacro.this.processingFailed(e, "interrupted", new Object[0]);
                }
            }

            public Expr visit(Expr.Shuttle shuttle) {
                return shuttle.visit(SleepExprMacro.this.apply(shuttle.visitAll(args)));
            }

            public boolean canVectorize(Expr.InputBindingInspector inspector) {
                return false;
            }

            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return null;
            }
        }
        return new SleepExpr(arg);
    }
}

