/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.auth;

import java.util.Base64;
import java.util.Objects;
import org.apache.dubbo.auth.exception.RpcAuthenticationException;
import org.apache.dubbo.auth.spi.Authenticator;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;

public class BasicAuthenticator
implements Authenticator {
    @Override
    public void sign(Invocation invocation, URL url) {
        String username = url.getParameter("username");
        String password = url.getParameter("password");
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        String authHeaderValue = "Basic " + encodedAuth;
        invocation.setAttachment("authorization", authHeaderValue);
    }

    @Override
    public void authenticate(Invocation invocation, URL url) throws RpcAuthenticationException {
        String username = url.getParameter("username");
        String password = url.getParameter("password");
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        String authHeaderValue = "Basic " + encodedAuth;
        if (!Objects.equals(authHeaderValue, invocation.getAttachment("Authorization")) && !Objects.equals(authHeaderValue, invocation.getAttachment("authorization"))) {
            throw new RpcAuthenticationException("Failed to authenticate, maybe consumer side did not enable the auth");
        }
    }
}

