/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.loadbalance;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.loadbalance.AbstractLoadBalance;

public class RandomLoadBalance
extends AbstractLoadBalance {
    public static final String NAME = "random";

    @Override
    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        int firstWeight;
        int length = invokers.size();
        boolean sameWeight = true;
        int[] weights = new int[length];
        weights[0] = firstWeight = this.getWeight(invokers.get(0), invocation);
        int totalWeight = firstWeight;
        for (int i = 1; i < length; ++i) {
            int weight;
            weights[i] = weight = this.getWeight(invokers.get(i), invocation);
            totalWeight += weight;
            if (!sameWeight || weight == firstWeight) continue;
            sameWeight = false;
        }
        if (totalWeight > 0 && !sameWeight) {
            int offset = ThreadLocalRandom.current().nextInt(totalWeight);
            for (int i = 0; i < length; ++i) {
                if ((offset -= weights[i]) >= 0) continue;
                return invokers.get(i);
            }
        }
        return invokers.get(ThreadLocalRandom.current().nextInt(length));
    }
}

