/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.registry;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;
import org.apache.dubbo.rpc.cluster.support.wrapper.MockClusterInvoker;

public class ZoneAwareClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(ZoneAwareClusterInvoker.class);

    public ZoneAwareClusterInvoker(Directory<T> directory) {
        super(directory);
    }

    @Override
    public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        Invoker<T> invoker2;
        for (Invoker<T> invoker3 : invokers) {
            ClusterInvoker clusterInvoker = (ClusterInvoker)invoker3;
            if (!clusterInvoker.isAvailable() || !clusterInvoker.getRegistryUrl().getParameter("preferred", false)) continue;
            return clusterInvoker.invoke(invocation);
        }
        String zone = invocation.getAttachment("registry_zone");
        if (StringUtils.isNotEmpty((String)zone)) {
            for (Invoker<T> invoker4 : invokers) {
                ClusterInvoker clusterInvoker = (ClusterInvoker)invoker4;
                if (!clusterInvoker.isAvailable() || !zone.equals(clusterInvoker.getRegistryUrl().getParameter("zone"))) continue;
                return clusterInvoker.invoke(invocation);
            }
            String string = invocation.getAttachment("registry_zone_force");
            if (StringUtils.isNotEmpty((String)string) && "true".equalsIgnoreCase(string)) {
                throw new IllegalStateException("No registry instance in zone or no available providers in the registry, zone: " + zone + ", registries: " + invokers.stream().map(invoker -> ((MockClusterInvoker)invoker).getRegistryUrl().toString()).collect(Collectors.joining(",")));
            }
        }
        if ((invoker2 = this.select(loadbalance, invocation, invokers, null)).isAvailable()) {
            return invoker2.invoke(invocation);
        }
        for (Invoker<T> invoker4 : invokers) {
            ClusterInvoker clusterInvoker = (ClusterInvoker)invoker4;
            if (!clusterInvoker.isAvailable()) continue;
            return clusterInvoker.invoke(invocation);
        }
        return invokers.get(0).invoke(invocation);
    }
}

