/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.route;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.cluster.governance.GovernanceRuleRepository;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshAppRuleListener;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshEnvListener;
import org.apache.dubbo.rpc.cluster.router.mesh.route.MeshEnvListenerFactory;
import org.apache.dubbo.rpc.cluster.router.mesh.util.MeshRuleListener;
import org.apache.dubbo.rpc.model.ModuleModel;

public class MeshRuleManager {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(MeshRuleManager.class);
    private final ConcurrentHashMap<String, MeshAppRuleListener> APP_RULE_LISTENERS = new ConcurrentHashMap();
    private final GovernanceRuleRepository ruleRepository;
    private final Set<MeshEnvListener> envListeners;

    public MeshRuleManager(ModuleModel moduleModel) {
        this.ruleRepository = (GovernanceRuleRepository)moduleModel.getDefaultExtension(GovernanceRuleRepository.class);
        Set envListenerFactories = moduleModel.getExtensionLoader(MeshEnvListenerFactory.class).getSupportedExtensionInstances();
        this.envListeners = envListenerFactories.stream().map(MeshEnvListenerFactory::getListener).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private synchronized MeshAppRuleListener subscribeAppRule(String app) {
        MeshAppRuleListener meshAppRuleListener = new MeshAppRuleListener(app);
        String appRuleDataId = app + ".MESHAPPRULE";
        try {
            String rawConfig = this.ruleRepository.getRule(appRuleDataId, "dubbo", 5000L);
            if (rawConfig != null) {
                meshAppRuleListener.receiveConfigInfo(rawConfig);
            }
        }
        catch (Throwable throwable) {
            logger.error("2-13", "failed to get mesh app route rule", "", "get MeshRuleManager app rule failed.", throwable);
        }
        this.ruleRepository.addListener(appRuleDataId, "dubbo", meshAppRuleListener);
        for (MeshEnvListener envListener : this.envListeners) {
            if (!envListener.isEnable()) continue;
            envListener.onSubscribe(app, meshAppRuleListener);
        }
        this.APP_RULE_LISTENERS.put(app, meshAppRuleListener);
        return meshAppRuleListener;
    }

    private synchronized void unsubscribeAppRule(String app, MeshAppRuleListener meshAppRuleListener) {
        String appRuleDataId = app + ".MESHAPPRULE";
        this.ruleRepository.removeListener(appRuleDataId, "dubbo", meshAppRuleListener);
        for (MeshEnvListener envListener : this.envListeners) {
            if (!envListener.isEnable()) continue;
            envListener.onUnSubscribe(app);
        }
    }

    public synchronized <T> void register(String app, MeshRuleListener subscriber) {
        MeshAppRuleListener meshAppRuleListener = this.APP_RULE_LISTENERS.get(app);
        if (meshAppRuleListener == null) {
            meshAppRuleListener = this.subscribeAppRule(app);
        }
        meshAppRuleListener.register(subscriber);
    }

    public synchronized <T> void unregister(String app, MeshRuleListener subscriber) {
        MeshAppRuleListener meshAppRuleListener = this.APP_RULE_LISTENERS.get(app);
        meshAppRuleListener.unregister(subscriber);
        if (meshAppRuleListener.isEmpty()) {
            this.unsubscribeAppRule(app, meshAppRuleListener);
            this.APP_RULE_LISTENERS.remove(app);
        }
    }

    @Deprecated
    public ConcurrentHashMap<String, MeshAppRuleListener> getAppRuleListeners() {
        return this.APP_RULE_LISTENERS;
    }
}

