/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterFactory;
import org.apache.dubbo.rpc.cluster.SingleRouterChain;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotSwitcher;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.StateRouter;
import org.apache.dubbo.rpc.cluster.router.state.StateRouterFactory;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class RouterChain<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(RouterChain.class);
    private final SingleRouterChain<T> mainChain;
    private final SingleRouterChain<T> backupChain;
    private volatile SingleRouterChain<T> currentChain;
    private final AtomicReference<BitList<Invoker<T>>> notifyingInvokers = new AtomicReference();

    public static <T> RouterChain<T> buildChain(Class<T> interfaceClass, URL url) {
        SingleRouterChain<T> chain1 = RouterChain.buildSingleChain(interfaceClass, url);
        SingleRouterChain<T> chain2 = RouterChain.buildSingleChain(interfaceClass, url);
        return new RouterChain<T>(new SingleRouterChain[]{chain1, chain2});
    }

    public static <T> SingleRouterChain<T> buildSingleChain(Class<T> interfaceClass, URL url) {
        ModuleModel moduleModel = url.getOrDefaultModuleModel();
        List extensionFactories = moduleModel.getExtensionLoader(RouterFactory.class).getActivateExtension(url, "router");
        List<Router> routers = extensionFactories.stream().map(factory -> factory.getRouter(url)).sorted(Router::compareTo).collect(Collectors.toList());
        List stateRouters = moduleModel.getExtensionLoader(StateRouterFactory.class).getActivateExtension(url, "router").stream().map(factory -> factory.getRouter(interfaceClass, url)).collect(Collectors.toList());
        boolean shouldFailFast = Boolean.parseBoolean(ConfigurationUtils.getProperty((ScopeModel)moduleModel, (String)"dubbo.router.should-fail-fast", (String)"true"));
        RouterSnapshotSwitcher routerSnapshotSwitcher = (RouterSnapshotSwitcher)ScopeModelUtil.getFrameworkModel((ScopeModel)moduleModel).getBeanFactory().getBean(RouterSnapshotSwitcher.class);
        return new SingleRouterChain(routers, stateRouters, shouldFailFast, routerSnapshotSwitcher);
    }

    public RouterChain(SingleRouterChain<T>[] chains) {
        if (chains.length != 2) {
            throw new IllegalArgumentException("chains' size should be 2.");
        }
        this.mainChain = chains[0];
        this.backupChain = chains[1];
        this.currentChain = this.mainChain;
    }

    public List<Invoker<T>> route(URL url, BitList<Invoker<T>> availableInvokers, Invocation invocation) {
        if (this.notifyingInvokers.get() != null && availableInvokers.getOriginList() == this.notifyingInvokers.get().getOriginList()) {
            this.switchToMainChain();
        }
        return this.currentChain.route(url, availableInvokers, invocation);
    }

    private void switchToMainChain() {
        this.currentChain = this.mainChain;
    }

    public synchronized void setInvokers(BitList<Invoker<T>> invokers, Runnable switchAction) {
        this.currentChain = this.backupChain;
        this.waitChain(this.mainChain);
        this.mainChain.setInvokers(invokers);
        this.notifyingInvokers.set(invokers);
        switchAction.run();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            logger.error("99-1", "", "", "Interrupted when waiting router chain.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.switchToMainChain();
        this.notifyingInvokers.set(null);
        this.waitChain(this.backupChain);
        this.backupChain.setInvokers(invokers);
    }

    private void waitChain(SingleRouterChain<T> oldChain) {
        try {
            Thread.sleep(1L);
            int waitTime = 0;
            while (oldChain.getCurrentConcurrency() != 0) {
                if (waitTime++ == 1000) {
                    logger.warn("1-40", "Wait router to long", "", "Wait router invoke end exceed 1000ms, router may stuck in.");
                }
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException t) {
            logger.error("99-1", "Wait router to interrupted", "", "Wait router to interrupted.");
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void destroy() {
        this.backupChain.destroy();
        this.currentChain = this.backupChain;
        this.waitChain(this.mainChain);
        this.mainChain.destroy();
    }

    public void addRouters(List<Router> routers) {
        this.mainChain.addRouters(routers);
        this.backupChain.addRouters(routers);
    }

    public SingleRouterChain<T> getCurrentChain() {
        return this.currentChain;
    }

    public List<Router> getRouters() {
        return this.currentChain.getRouters();
    }

    public StateRouter<T> getHeadStateRouter() {
        return this.currentChain.getHeadStateRouter();
    }

    @Deprecated
    public List<StateRouter<T>> getStateRouters() {
        return this.currentChain.getStateRouters();
    }
}

