/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.merger;

import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.rpc.cluster.Merger;

public class FloatArrayMerger
implements Merger<float[]> {
    public float[] merge(float[] ... items) {
        if (ArrayUtils.isEmpty((Object[])items)) {
            return new float[0];
        }
        int total = 0;
        for (float[] array : items) {
            if (array == null) continue;
            total += array.length;
        }
        float[] result = new float[total];
        int index = 0;
        for (float[] array : items) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, index, array.length);
            index += array.length;
        }
        return result;
    }
}

