/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.file;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.IOUtils;
import org.apache.dubbo.rpc.cluster.router.state.StateRouter;
import org.apache.dubbo.rpc.cluster.router.state.StateRouterFactory;

public class FileStateRouterFactory
implements StateRouterFactory {
    public static final String NAME = "file";
    private StateRouterFactory routerFactory;

    public void setRouterFactory(StateRouterFactory routerFactory) {
        this.routerFactory = routerFactory;
    }

    @Override
    public <T> StateRouter<T> getRouter(Class<T> interfaceClass, URL url) {
        try {
            int i;
            String protocol = url.getParameter("router", "script");
            String type = null;
            String path = url.getPath();
            if (path != null && (i = path.lastIndexOf(46)) > 0) {
                type = path.substring(i + 1);
            }
            String rule = IOUtils.read((Reader)new FileReader(url.getAbsolutePath()));
            boolean runtime = url.getParameter("runtime", false);
            ServiceConfigURL script = URLBuilder.from((URL)url).setProtocol(protocol).addParameter("type", type).addParameter("runtime", runtime).addParameterAndEncoded("rule", rule).build();
            return this.routerFactory.getRouter(interfaceClass, (URL)script);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

