/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.state;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.governance.GovernanceRuleRepository;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.StateRouter;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public abstract class AbstractStateRouter<T>
implements StateRouter<T> {
    private volatile boolean force = false;
    private volatile URL url;
    private volatile StateRouter<T> nextRouter = null;
    private final GovernanceRuleRepository ruleRepository;
    private final boolean shouldFailFast;
    protected ModuleModel moduleModel;

    public AbstractStateRouter(URL url) {
        this.moduleModel = url.getOrDefaultModuleModel();
        this.ruleRepository = (GovernanceRuleRepository)this.moduleModel.getExtensionLoader(GovernanceRuleRepository.class).getDefaultExtension();
        this.url = url;
        this.shouldFailFast = Boolean.parseBoolean(ConfigurationUtils.getProperty((ScopeModel)this.moduleModel, (String)"dubbo.router.should-fail-fast", (String)"true"));
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    @Override
    public boolean isRuntime() {
        return true;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public GovernanceRuleRepository getRuleRepository() {
        return this.ruleRepository;
    }

    public StateRouter<T> getNextRouter() {
        return this.nextRouter;
    }

    @Override
    public void notify(BitList<Invoker<T>> invokers) {
    }

    @Override
    public final BitList<Invoker<T>> route(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> nodeHolder) throws RpcException {
        BitList<Invoker<T>> routeResult;
        if (needToPrintMessage && (nodeHolder == null || nodeHolder.get() == null)) {
            needToPrintMessage = false;
        }
        RouterSnapshotNode currentNode = null;
        RouterSnapshotNode parentNode = null;
        Holder messageHolder = null;
        if (needToPrintMessage) {
            parentNode = (RouterSnapshotNode)nodeHolder.get();
            currentNode = new RouterSnapshotNode(this.getClass().getSimpleName(), invokers.clone());
            parentNode.appendNode(currentNode);
            if (parentNode.getNodeOutputSize() < invokers.size()) {
                parentNode.setNodeOutputInvokers(invokers.clone());
            }
            messageHolder = new Holder();
            nodeHolder.set(currentNode);
        }
        if ((routeResult = this.doRoute(invokers, url, invocation, needToPrintMessage, nodeHolder, messageHolder)) != invokers) {
            routeResult = invokers.and(routeResult);
        }
        if (!(this.supportContinueRoute() || this.shouldFailFast && routeResult.isEmpty())) {
            routeResult = this.continueRoute(routeResult, url, invocation, needToPrintMessage, nodeHolder);
        }
        if (needToPrintMessage) {
            currentNode.setRouterMessage((String)messageHolder.get());
            if (currentNode.getNodeOutputSize() == 0) {
                currentNode.setNodeOutputInvokers(routeResult.clone());
            }
            currentNode.setChainOutputInvokers(routeResult.clone());
            nodeHolder.set((Object)parentNode);
        }
        return routeResult;
    }

    protected abstract BitList<Invoker<T>> doRoute(BitList<Invoker<T>> var1, URL var2, Invocation var3, boolean var4, Holder<RouterSnapshotNode<T>> var5, Holder<String> var6) throws RpcException;

    protected final BitList<Invoker<T>> continueRoute(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> nodeHolder) {
        if (this.nextRouter != null) {
            return this.nextRouter.route(invokers, url, invocation, needToPrintMessage, nodeHolder);
        }
        return invokers;
    }

    protected boolean supportContinueRoute() {
        return false;
    }

    @Override
    public final void setNextRouter(StateRouter<T> nextRouter) {
        this.nextRouter = nextRouter;
    }

    @Override
    public final String buildSnapshot() {
        return this.doBuildSnapshot() + "            v \n" + this.nextRouter.buildSnapshot();
    }

    protected String doBuildSnapshot() {
        return this.getClass().getSimpleName() + " not support\n";
    }
}

