/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter.support;

import java.util.Optional;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.model.ServiceModel;

@Activate(group={"consumer"}, order=-2147483548)
public class ConsumerClassLoaderFilter
implements ClusterFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        ClassLoader originClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Optional.ofNullable(invocation.getServiceModel()).map(ServiceModel::getClassLoader).ifPresent(Thread.currentThread()::setContextClassLoader);
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originClassLoader);
        }
    }
}

