/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match;

import java.net.UnknownHostException;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.UrlUtils;

public class AddressMatch {
    public static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AddressMatch.class);
    private String wildcard;
    private String cird;
    private String exact;

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getCird() {
        return this.cird;
    }

    public void setCird(String cird) {
        this.cird = cird;
    }

    public String getExact() {
        return this.exact;
    }

    public void setExact(String exact) {
        this.exact = exact;
    }

    public boolean isMatch(String input) {
        if (this.getCird() != null && input != null) {
            try {
                return input.equals(this.getCird()) || NetUtils.matchIpExpression((String)this.getCird(), (String)input);
            }
            catch (UnknownHostException e) {
                logger.error("2-7", "Executing routing rule match expression error.", "", String.format("Error trying to match cird formatted address %s with input %s in AddressMatch.", this.getCird(), input), (Throwable)e);
            }
        }
        if (this.getWildcard() != null && input != null) {
            if ("0.0.0.0".equals(this.getWildcard()) || "*".equals(this.getWildcard())) {
                return true;
            }
            return UrlUtils.isMatchGlobPattern((String)this.getWildcard(), (String)input);
        }
        if (this.getExact() != null && input != null) {
            return input.equals(this.getExact());
        }
        return false;
    }
}

